package com.xforceplus.seller.invoice.client.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Size;
import java.math.BigDecimal;

@Data
public class RestRedNotificationMain {

    @ApiModelProperty("申请流水号")
    private String sellerNumber;

    @ApiModelProperty("申请类型")
    private Integer applyType;

    @ApiModelProperty("成品油申请原因")
    private String petroleumReason;

    @ApiModelProperty("发票类型")
    private String invoiceType;

    @ApiModelProperty("原发票类型")
    private String originInvoiceType;

    @ApiModelProperty("原蓝字发票代码")
    private String invoiceCode;

    @ApiModelProperty("原蓝字发票号码")
    private String invoiceNo;

    @ApiModelProperty("销方名称")
    private String sellerName;

    @ApiModelProperty("销方税号")
    private String sellerTaxNo;

    @ApiModelProperty("购方名称")
    private String purchaserName;

    @ApiModelProperty("购方名称税号")
    private String purchaserTaxNo;

    @ApiModelProperty("价税合计")
    private BigDecimal amountWithTax;

    @ApiModelProperty("合计金额")
    private BigDecimal amountWithoutTax;

    @ApiModelProperty("合计税额")
    private BigDecimal taxAmount;

    @ApiModelProperty("业务单号")
    @Size(max = 50, message = "业务单号最大长度为50")
    private String billNo;

    @ApiModelProperty("扣除额")
    private BigDecimal deduction;

    @ApiModelProperty("申请人名称")
    private String proposerName;

    @ApiModelProperty("申请人电话")
    private String proposerTel;

    @ApiModelProperty("开票日期")
    private String paperDrawDate;

    @ApiModelProperty("销方编号")
    private String sellerNo;

    @ApiModelProperty("购方编号")
    private String purchaserNo;

    @ApiModelProperty("业务单类型")
    @Size(max = 50, message = "业务单类型最大长度为50")
    private String salesbillType;

    @ApiModelProperty(value = "业务类型", notes = "AP：购方 AR-销方")
    private String businessBillType;

    @ApiModelProperty("预制发票Id")
    private Long invoiceId;

    @ApiModelProperty(value = "协同标识", notes = "0 不协同， 1协同")
    private Integer cooperateFlag;

    @ApiModelProperty("创建人")
    private Long createUser;

    @ApiModelProperty("发票颜色")
    private Integer invoiceColor;

    @ApiModelProperty(value = "红字信息来源", notes = "0 excel 1 发票 2 预制发票")
    private Integer invoiceOrigin;

    @ApiModelProperty(value = "红字信息导入批次号，兼容历史数据")
    private Long importBatchNo;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("申请终端")
    private String proposerTerminal;

    @ApiModelProperty("税率")
    private String taxRate;

    @ApiModelProperty("1 销方 2购方")
    private Integer userRole;

    @ApiModelProperty("组织权限Id")
    private Long sysOrgId;

    @ApiModelProperty("开票机号")
    private String machineCode;

    @ApiModelProperty("销方集团id")
    private String sellerGroupId;

    @ApiModelProperty("销方租户id")
    private String sellerTenantId;

    @ApiModelProperty("销方组织ID")
    private String sellerId;

    @ApiModelProperty("购方集团id")
    private String purchaserGroupId;

    @ApiModelProperty("购方租户id")
    private String purchaserTenantId;

    @ApiModelProperty("购方组织ID")
    private String purchaserId;

    @ApiModelProperty("特殊发票标识")
    private Integer specialInvoiceFlag;

    private String ext1;

    private String ext2;

    private String ext3;

    private String ext4;

    private String ext5;

    private String ext6;

    private String ext7;

    private String ext8;

    private String ext9;

    private String ext10;

    private String ext11;

    private String ext12;

    private String ext13;

    private String ext14;

    private String ext15;

    private String ext16;

    private String ext17;

    private String ext18;

    private String ext19;

    private String ext20;

    private String ext21;

    private String ext22;

    private String ext23;

    private String ext24;

    private String ext25;

    @ApiModelProperty("申请原因")
    private String reason;

}
