package com.xforceplus.seller.invoice.client.model.pdf;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

@ApiModel(
        description = "购方信息"
)
@JsonInclude(Include.NON_NULL)
public class AutoPdfPurchaserInfo {

    @JsonProperty("purchaserAddress")
    private String purchaserAddress = null;
    @JsonProperty("purchaserBank")
    private String purchaserBank = null;
    @JsonProperty("purchaserBankAccount")
    private String purchaserBankAccount = null;
    @JsonProperty("purchaserName")
    private String purchaserName = null;
    @JsonProperty("purchaserTaxCode")
    private String purchaserTaxCode = null;
    @JsonProperty("purchaserTelNo")
    private String purchaserTelNo = null;

    public AutoPdfPurchaserInfo(String purchaserAddress, String purchaserBank, String purchaserBankAccount, String purchaserName, String purchaserTaxCode, String purchaserTelNo) {
        this.purchaserAddress = purchaserAddress;
        this.purchaserBank = purchaserBank;
        this.purchaserBankAccount = purchaserBankAccount;
        this.purchaserName = purchaserName;
        this.purchaserTaxCode = purchaserTaxCode;
        this.purchaserTelNo = purchaserTelNo;
    }

    public AutoPdfPurchaserInfo() {
    }

    @JsonIgnore
    public AutoPdfPurchaserInfo purchaserTaxCode(String purchaserTaxCode) {
        this.purchaserTaxCode = purchaserTaxCode;
        return this;
    }

    @ApiModelProperty("购方税号")
    public String getPurchaserTaxCode() {
        return this.purchaserTaxCode;
    }

    public void setPurchaserTaxCode(String purchaserTaxCode) {
        this.purchaserTaxCode = purchaserTaxCode;
    }

    @JsonIgnore
    public AutoPdfPurchaserInfo purchaserName(String purchaserName) {
        this.purchaserName = purchaserName;
        return this;
    }

    @ApiModelProperty("购方名称")
    public String getPurchaserName() {
        return this.purchaserName;
    }

    public void setPurchaserName(String purchaserName) {
        this.purchaserName = purchaserName;
    }

    @JsonIgnore
    public AutoPdfPurchaserInfo purchaserAddress(String purchaserAddress) {
        this.purchaserAddress = purchaserAddress;
        return this;
    }

    @ApiModelProperty("购方地址")
    public String getPurchaserAddress() {
        return this.purchaserAddress;
    }

    public void setPurchaserAddress(String purchaserAddress) {
        this.purchaserAddress = purchaserAddress;
    }

    @JsonIgnore
    public AutoPdfPurchaserInfo purchaserTelNo(String purchaserTelNo) {
        this.purchaserTelNo = purchaserTelNo;
        return this;
    }

    @ApiModelProperty("购方电话")
    public String getPurchaserTelNo() {
        return this.purchaserTelNo;
    }

    public void setPurchaserTelNo(String purchaserTelNo) {
        this.purchaserTelNo = purchaserTelNo;
    }

    @JsonIgnore
    public AutoPdfPurchaserInfo purchaserBank(String purchaserBank) {
        this.purchaserBank = purchaserBank;
        return this;
    }

    @ApiModelProperty("购方银行")
    public String getPurchaserBank() {
        return this.purchaserBank;
    }

    public void setPurchaserBank(String purchaserBank) {
        this.purchaserBank = purchaserBank;
    }

    @JsonIgnore
    public AutoPdfPurchaserInfo purchaserBankAccount(String purchaserBankAccount) {
        this.purchaserBankAccount = purchaserBankAccount;
        return this;
    }

    @ApiModelProperty("购方账号")
    public String getPurchaserBankAccount() {
        return this.purchaserBankAccount;
    }

    public void setPurchaserBankAccount(String purchaserBankAccount) {
        this.purchaserBankAccount = purchaserBankAccount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AutoPdfPurchaserInfo that = (AutoPdfPurchaserInfo) o;
        return Objects.equals(purchaserAddress, that.purchaserAddress) &&
                Objects.equals(purchaserBank, that.purchaserBank) &&
                Objects.equals(purchaserBankAccount, that.purchaserBankAccount) &&
                Objects.equals(purchaserName, that.purchaserName) &&
                Objects.equals(purchaserTaxCode, that.purchaserTaxCode) &&
                Objects.equals(purchaserTelNo, that.purchaserTelNo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(purchaserAddress, purchaserBank, purchaserBankAccount, purchaserName, purchaserTaxCode, purchaserTelNo);
    }

    @Override
    public String toString() {
        return "AutoPdfPurchaserInfo{" +
                "purchaserAddress='" + purchaserAddress + '\'' +
                ", purchaserBank='" + purchaserBank + '\'' +
                ", purchaserBankAccount='" + purchaserBankAccount + '\'' +
                ", purchaserName='" + purchaserName + '\'' +
                ", purchaserTaxCode='" + purchaserTaxCode + '\'' +
                ", purchaserTelNo='" + purchaserTelNo + '\'' +
                '}';
    }

    private String toIndentedString(Object o) {
        return o == null ? "null" : o.toString().replace("\n", "\n    ");
    }
}
