package com.xforceplus.seller.invoice.client;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.seller.invoice.client.model.SellerInvoiceInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 统计信息分页返回结果
 */
@ApiModel(description = "统计信息分页返回结果")

@JsonInclude(NON_NULL)
public class StatisticsPageQueryResult {

  @JsonProperty("total")
  private Long total = 0L;

  @JsonProperty("list")
  private List<SellerStatisticsInfo> list = new ArrayList<SellerStatisticsInfo>();

   /**
   * 总条数
   * @return total
  **/
  @ApiModelProperty(value = "总条数")
  public Long getTotal() {
    return total;
  }

  public void setTotal(Long total) {
    this.total = total;
  }

  @JsonIgnore
  public StatisticsPageQueryResult list(List<SellerStatisticsInfo> list) {
    this.list = list;
    return this;
  }

  public StatisticsPageQueryResult addListItem(SellerStatisticsInfo listItem) {
    this.list.add(listItem);
    return this;
  }

  /**
   * 发票信息查询列表
   * @return list
  **/
  @ApiModelProperty(value = "发票信息查询列表")
  public List<SellerStatisticsInfo> getList() {
    return list;
  }

  public void setList(List<SellerStatisticsInfo> list) {
    this.list = list;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StatisticsPageQueryResult invoicePageQueryResult = (StatisticsPageQueryResult) o;
    return Objects.equals(this.total, invoicePageQueryResult.total) &&
        Objects.equals(this.list, invoicePageQueryResult.list);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total, list);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StatisticsPageQueryResult {\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    list: ").append(toIndentedString(list)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
