package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.BillOfPreInvoiceRequest;
import com.xforceplus.xplatframework.model.Response;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "billOfPreInvoice", description = "the billOfPreInvoice API")
public interface BillOfPreInvoiceApi {

    @ApiOperation(value = "查询预制发票所属单据主信息", notes = "", response = Response.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerPreInvoice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询结果", response = Response.class) })
    @RequestMapping(value = "/billOfPreInvoice/queryBillOfPreInvoiceItem",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     Response queryBillOfPreInvoiceItem(@ApiParam(value = "明细请求参数") @RequestBody BillOfPreInvoiceRequest billOfPreInvoiceRequest);


    @ApiOperation(value = "查询预制发票所属单据主信息", notes = "", response = Response.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerPreInvoice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询结果", response = Response.class) })
    @RequestMapping(value = "/billOfPreInvoice/queryBillOfPreInvoiceMain",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     Response queryBillOfPreInvoiceMain(@ApiParam(value = "主信息请求参数") @RequestBody BillOfPreInvoiceRequest billOfPreInvoiceRequest);

}
