package com.xforceplus.seller.invoice.client.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Map;

@ApiModel("总线分发消息")
@Data
public class DispatchMessageModel {
    @ApiModelProperty("下发消息唯一标识")
    private Long msgId;
    @ApiModelProperty("消息类型")
    private Integer msgType;
    @ApiModelProperty("事件类型")
    private Integer eventType;
    @ApiModelProperty("购方租户Id")
    private Long sellerTenantId;
    @ApiModelProperty("销方租户Id")
    private Long purchaserTenantId;
    @ApiModelProperty("AR/AP类型")
    private String businessBillType;
    @ApiModelProperty("发票类型")
    private String invoiceType;
    @ApiModelProperty("业务单类型")
    private String billType;
    @ApiModelProperty("扩展属性")
    private Map<String, Object> extAttributeMap;
    @ApiModelProperty("消息头")
    private Map<String, Object> header;
    @ApiModelProperty("反向协同队列")
    private Boolean isReverseSyn;
    @ApiModelProperty("下发通道")
    private Integer destChannel;
    @ApiModelProperty("下发队列名")
    private String destQueueName;

}
