package com.xforceplus.seller.invoice.client.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 发票详情--包含发票详情信息、发票明细列表信息、发票操作日志列表信息
 */
@ApiModel(description = "发票信息--包含发票详情信息、发票明细列表信息、发票操作日志列表信息")
@JsonInclude(NON_NULL)
@EqualsAndHashCode
@ToString
@Data
public class InvoiceWithDetails {
  @JsonProperty("id")
  @JSONField(serializeUsing = ToStringSerializer.class)
  private Long id = null;
  @JsonProperty("preInvoiceId")
  @ApiModelProperty("预制发票序列号主键")
  private Long preInvoiceId = null;
  @JsonProperty("batchNo")
  @ApiModelProperty("批次号")
  private Long batchNo = null;
  @JsonProperty("outBatchNo")
  @ApiModelProperty("外部批次号-默认值和批次号相同")
  private Long outBatchNo = null;
  @JsonProperty("salesbillId")
  @ApiModelProperty("单据Id")
  private String salesbillId = null;
  @JsonProperty("salesbillNo")
  @ApiModelProperty("单据No")
  private String salesbillNo = null;
  @JsonProperty("sellerTenantId")
  @ApiModelProperty("销方租户Id")
  private Long sellerTenantId = null;
  @JsonProperty("sellerGroupId")
  @ApiModelProperty("销方集团Id 同 sellerTenantId")
  private Long sellerGroupId = null;
  @JsonProperty("sellerNo")
  @ApiModelProperty("销方租户公司编号")
  private String sellerNo = null;
  @JsonProperty("sellerId")
  @ApiModelProperty("销方租户公司Id")
  private Long sellerId = null;
  @JsonProperty("sellerCode")
  @ApiModelProperty("销方公司代码")
  private String sellerCode = null;
  @JsonProperty("sellerName")
  @ApiModelProperty("销方名称")
  private String sellerName = null;
  @JsonProperty("sellerTaxNo")
  @ApiModelProperty("销方税号")
  private String sellerTaxNo = null;
  @JsonProperty("sellerTel")
  @ApiModelProperty("销方公司电话")
  private String sellerTel = null;
  @JsonProperty("sellerAddress")
  @ApiModelProperty("销方公司地址")
  private String sellerAddress = null;
  @JsonProperty("sellerBankName")
  @ApiModelProperty("销方银行名称")
  private String sellerBankName = null;
  @JsonProperty("sellerBankAccount")
  @ApiModelProperty("销方银行账号")
  private String sellerBankAccount = null;
  @JsonProperty("purchaserName")
  @ApiModelProperty("购方名称")
  private String purchaserName = null;
  @JsonProperty("purchaserTenantId")
  @ApiModelProperty("购方租户Id")
  private Long purchaserTenantId = null;
  @JsonProperty("purchaserGroupId")
  @ApiModelProperty("购方集团Id")
  private Long purchaserGroupId = null;
  @JsonProperty("purchaserId")
  @ApiModelProperty("购方公司Id")
  private Long purchaserId = null;
  @JsonProperty("purchaserNo")
  @ApiModelProperty("购方公司No")
  private String purchaserNo = null;
  @JsonProperty("purchaserTaxNo")
  @ApiModelProperty("购方公司税号")
  private String purchaserTaxNo = null;
  @JsonProperty("purchaserTel")
  @ApiModelProperty("购方公司电话")
  private String purchaserTel = null;
  @JsonProperty("purchaserAddress")
  @ApiModelProperty("购方公司地址")
  private String purchaserAddress = null;
  @JsonProperty("purchaserBankName")
  @ApiModelProperty("购方银行名称")
  private String purchaserBankName = null;
  @JsonProperty("purchaserBankAccount")
  @ApiModelProperty("购方银行账号")
  private String purchaserBankAccount = null;
  @JsonProperty("purchaserEPayId")
  @ApiModelProperty(value = "购方电子支付标识")
  private String purchaserEPayId = "";
  @JsonProperty("invoiceType")
  @ApiModelProperty(value = "发票类型")
  private String invoiceType = null;
  @JsonProperty("invoiceKind")
  @ApiModelProperty(value = "发票票种")
  private String invoiceKind = null;
  @JsonProperty("taxInvoiceSource")
  @ApiModelProperty(value = "国税来源")
  private String taxInvoiceSource =null;
  @JsonProperty("invoiceColor")
  @ApiModelProperty(value = "发票红蓝标识")
  private String invoiceColor = null;
  @JsonProperty("invoiceCode")
  @ApiModelProperty(value = "发票代码")
  private String invoiceCode = null;
  @JsonProperty("invoiceNo")
  @ApiModelProperty(value = "发票号码")
  private String invoiceNo = null;
  @JsonProperty("machineCode")
  @ApiModelProperty(value = "机器编码")
  private String machineCode = null;
  @JsonProperty("terminalType")
  @ApiModelProperty(value = "开具方式")
  private int terminalType;
  @JsonProperty("paperDrawDate")
  @ApiModelProperty(value = "开票日期")
  private Date paperDrawDate = null;
  @JsonProperty("checkCode")
  @ApiModelProperty(value = "校验码")
  private String checkCode = null;
  @JsonProperty("cashierName")
  @ApiModelProperty(value = "收款人")
  private String cashierName = null;
  @JsonProperty("checkerName")
  @ApiModelProperty(value = "复核人")
  private String checkerName = null;
  @JsonProperty("invoicerName")
  @ApiModelProperty(value = "开票人")
  private String invoicerName = null;
  @JsonProperty("remark")
  @ApiModelProperty(value = "备注")
  private String remark = null;
  @JsonProperty("electronicSignature")
  @ApiModelProperty(value = "电子签名")
  private String electronicSignature = null;
  @JsonProperty("invoiceOrigin")
  @ApiModelProperty(value = "发票来源")
  private String invoiceOrigin = null;
  @JsonProperty("invoiceFrom")
  @ApiModelProperty(value = "发票来源方")
  private String invoiceFrom = null;
  @JsonProperty("systemOrig")
  @ApiModelProperty(value = "系统来源")
  private String systemOrig = null;
  @JsonProperty("specialInvoiceFlag")
  @ApiModelProperty(value = "特殊发票标记  0-默认  1-通行费   2-成品油 3-区块链发票 4-机动车专票 5-8特殊机票种  9-矿产品")
  private String specialInvoiceFlag = null;
  @JsonProperty("billType")
  @ApiModelProperty(value = "单据类型")
  private String billType = null;
  @JsonProperty("businessBillType")
  @ApiModelProperty(value = "业务单据类型")
  private String businessBillType = null;
  @JsonProperty("amountWithTax")
  @ApiModelProperty(value = "含税金额")
  private BigDecimal amountWithTax = null;
  @JsonProperty("amountWithoutTax")
  @ApiModelProperty(value = "不含税金额")
  private BigDecimal amountWithoutTax = null;
  @JsonProperty("taxAmount")
  @ApiModelProperty(value = "税额")
  private BigDecimal taxAmount = null;
  @JsonProperty("taxAmountStr")
  @ApiModelProperty(value = "税额（字符串格式）")
  private String taxAmountStr = null;
  @JsonProperty("taxRate")
  @ApiModelProperty(value = "税率")
  private String taxRate = null;
  @JsonProperty("taxRateStr")
  @ApiModelProperty(value = "税率（字符串格式）")
  private String taxRateStr;
  @JsonProperty("amountWithoutTaxStr")
  @ApiModelProperty("显示不含税金额")
  private String amountWithoutTaxStr;
  @JsonProperty("amountWithTaxStr")
  @ApiModelProperty("显示含税金额")
  private String amountWithTaxStr;
  @JsonProperty("originInvoiceNo")
  @ApiModelProperty("原发票号码")
  private String originInvoiceNo = null;
  @JsonProperty("originInvoiceCode")
  @ApiModelProperty("原发票代码")
  private String originInvoiceCode = null;
  @JsonProperty("cipherText")
  @ApiModelProperty("密文")
  private String cipherText = null;
  @JsonProperty("cipherTextTwoCode")
  @ApiModelProperty("二维密文")
  private String cipherTextTwoCode = null;
  @JsonProperty("virtualFlag")
  @ApiModelProperty("虚拟标志")
  private String virtualFlag = null;
  @JsonProperty("abandonFlag")
  @ApiModelProperty("作废标识 0-默认 1-批次内 2-批次外")
  private String abandonFlag = null;

  @JsonProperty("redTime")
  @ApiModelProperty("红冲时间")
  private Date redTime = null;
  @JsonProperty("redFlag")
  @ApiModelProperty("红冲状态1-待红冲 2-待部分红冲3-红冲4-部分红冲 （目前该字段没用）")
  private String redFlag = null;
  @JsonProperty("redNotificationNo")
  @ApiModelProperty("红字信息表编号")
  private String redNotificationNo = null;
  @JsonProperty("status")
  @ApiModelProperty("发票状态1-正常 0-作废 2-待处理")
  private Integer status = null;
  @JsonProperty("matchedStatus")
  @ApiModelProperty("阳光城-生成凭证后锁定、解锁标志  0-解锁  1-锁定")
  private Integer matchedStatus = null;
  @JsonProperty("saleListFileFlag")
  @ApiModelProperty("销货清单文件打印标志（0-否,1-是）默认0")
  private Integer saleListFileFlag = null;
  @JsonProperty("printContentFlag")
  @ApiModelProperty("打印内容标志0-打印单价和数量1-不打印单价和数量,默认0")
  private Integer printContentFlag = null;
  @JsonProperty("displayPriceQality")
  @ApiModelProperty("打印内容标志0-打印单价和数量1-不打印单价和数量,默认0")
  private Integer displayPriceQality = null;
  @JsonProperty("ofdPath")
  private String ofdPath;
  @JsonProperty("pdfPath")
  private String pdfPath = null;
  @JsonProperty("receiveUserEmail")
  private String receiveUserEmail = null;
  @JsonProperty("makeOutUnitName")
  private String makeOutUnitName = null;
  @JsonProperty("handleStatus")
  private String handleStatus = null;
  @JsonProperty("handleRemark")
  private String handleRemark = null;
  @JsonProperty("outCheckStatus")
  private String outCheckStatus = null;
  @JsonProperty("lockFlag")
  private Integer lockFlag = null;
  @JsonProperty("identifyStatus")
  private String identifyStatus = null;
  @JsonProperty("printStatus")
  private String printStatus = null;
  @JsonProperty("retreatStatus")
  private String retreatStatus;
  @JsonProperty("paymentStatus")
  private String paymentStatus;
  @JsonProperty("makeOutUnitCode")
  private String makeOutUnitCode = null;
  @JsonProperty("createUserName")
  private String createUserName = null;
  @JsonProperty("createTime")
  private Date createTime = null;
  @JsonProperty("createUserId")
  private String createUserId = null;
  @JsonProperty("updateTime")
  private Date updateTime = null;
  @JsonProperty("updateUserId")
  private String updateUserId = null;
  @JsonProperty("updateUserName")
  private String updateUserName;
  @JsonProperty("deposeUserName")
  private String deposeUserName = null;
  @JsonProperty("deposeTime")
  private Date deposeTime = null;
  @JsonProperty("deposeUserId")
  private String deposeUserId = null;
  @JsonProperty("sysOrgId")
  private Long sysOrgId = null;
  @JsonProperty("sysOrgName")
  private String sysOrgName = null;
  @JsonProperty("customerNo")
  private String customerNo = null;
  @JsonProperty("invoiceUrl")
  private String invoiceUrl = null;
  @JsonProperty("ext1")
  private String ext1 = null;
  @JsonProperty("ext2")
  private String ext2 = null;
  @JsonProperty("ext3")
  private String ext3 = null;
  @JsonProperty("ext4")
  private String ext4 = null;
  @JsonProperty("ext5")
  private String ext5 = null;
  @JsonProperty("ext6")
  private String ext6 = null;
  @JsonProperty("ext7")
  private String ext7 = null;
  @JsonProperty("ext8")
  private String ext8 = null;
  @JsonProperty("ext9")
  private String ext9 = null;
  @JsonProperty("ext10")
  private String ext10 = null;
  @JsonProperty("ext11")
  private String ext11 = null;
  @JsonProperty("ext12")
  private String ext12 = null;
  @JsonProperty("ext13")
  private String ext13 = null;
  @JsonProperty("ext14")
  private String ext14 = null;
  @JsonProperty("ext15")
  private String ext15 = null;
  @JsonProperty("ext16")
  private String ext16 = null;
  @JsonProperty("ext17")
  private String ext17 = null;
  @JsonProperty("ext18")
  private String ext18 = null;
  @JsonProperty("ext19")
  private String ext19 = null;
  @JsonProperty("ext20")
  private String ext20 = null;
  @JsonProperty("ext21")
  private String ext21 = null;
  @JsonProperty("ext22")
  private String ext22 = null;
  @JsonProperty("ext23")
  private String ext23 = null;
  @JsonProperty("ext24")
  private String ext24 = null;
  @JsonProperty("ext25")
  private String ext25 = null;
  @JsonProperty("addressee")
  @ApiModelProperty("物流 收件人")
  private String addressee = null;
  @JsonProperty("addresseeTel")
  @ApiModelProperty("物流-收件人电话")
  private String addresseeTel = null;
  @JsonProperty("addresseeProvince")
  @ApiModelProperty("物流-收件人省份")
  private String addresseeProvince = null;
  @JsonProperty("addresseeCity")
  @ApiModelProperty("物流-收件人城市")
  private String addresseeCity = null;
  @JsonProperty("addresseeCounty")
  @ApiModelProperty("物流-收件人所在县区")
  private String addresseeCounty = null;
  @JsonProperty("direction")
  @ApiModelProperty("物流-收件人地址")
  private String direction = null;
  @JsonProperty("logisticRemark")
  @ApiModelProperty("物流备注")
  private String logisticRemark = null;
  @JsonProperty("addresseeComp")
  @ApiModelProperty("收件人单位")
  private String addresseeComp = null;
  @JsonProperty("addresseePost")
  @ApiModelProperty("收件人邮编")
  private String addresseePost = null;
  @JsonProperty("auditType")
  private Integer auditType;
  @JsonProperty("deviceUn")
  @ApiModelProperty("设备唯一码")
  private String deviceUn;
  @JsonProperty("terminalUn")
  @ApiModelProperty("终端唯一码")
  private String terminalUn;
  @JsonProperty("orderNos")
  private String orderNos = null;
  @JsonProperty("discountRate")
  private String discountRate = null;
  @JsonProperty("sellerBankInfo")
  private String sellerBankInfo;
  @JsonProperty("sellerAddrTel")
  private String sellerAddrTel;
  @JsonProperty("purchaserBankInfo")
  private String purchaserBankInfo;

  @JsonProperty("purchaserAddrTel")
  private String purchaserAddrTel;
  @JsonProperty("originPaperDrawDate")
  private String originPaperDrawDate = null;
  @JsonProperty("makeType")
  private Integer makeType = 0;
  @JsonProperty("xmlUrl")
  private String xmlUrl;

  @ApiModelProperty("原发票类型")
  private String originInvoiceType;

  @ApiModelProperty("红冲人")
  private String redUserName;

  @ApiModelProperty("接收人电话")
  private String receiveUserTel;

  @ApiModelProperty("渠道")
  private String channel;

  @ApiModelProperty("数电发票号码")
  private String allElectricInvoiceNo;

  @ApiModelProperty("系统来源类型")
  private Integer systemOrigType;

  @ApiModelProperty("购方类型")
  private Integer purchaserType;
  @JsonProperty("specialAdditions")
  @ApiModelProperty("特殊票种信息")
  private List<Map<String, Object>> specialAdditions;
  @JsonProperty("originType")
  @ApiModelProperty("来源方式 0-默认 21-扫码验真 22-手工验真 23-导入验真 24-识别验真")
  private Integer originType;
  @JsonProperty("associateStatus")
  @ApiModelProperty("关联状态 0-默认 1-关联中 2-关联成功 3-关联失败")
  private Integer associateStatus;
  @JsonProperty("scanStatus")
  @ApiModelProperty("扫描状态 0-未扫描 1-已扫描")
  private Integer scanStatus;
  @JsonProperty("imageUploadStatus")
  @ApiModelProperty("影像上传状态 0-未上传 1-已上传")
  private Integer imageUploadStatus;
  @ApiModelProperty("签收状态 0-无物流信息 1-未签收 2-已签收")
  private Integer receiptStatus;
  @ApiModelProperty("审核状态 0-未审核 1-已审核")
  private Integer approveStatus;
  @ApiModelProperty("协同状态 0-不协同 1-协同")
  private Integer cooperateFlag;
  @ApiModelProperty("代开机构税号")
  private String agencyTaxNo;
  @ApiModelProperty("代开机构名称")
  private String agencyName;
  @ApiModelProperty("是否是代开发票 0否 1是")
  private Integer isAgency;
  @ApiModelProperty("查验发送时间")
  private Date verifyRequestTime;
  @ApiModelProperty("查验完成时间")
  private Date verifyResponseTime;
  @ApiModelProperty("查验备注")
  private String verifyRemark;
  @ApiModelProperty("关联时间")
  private Date associateTime;
  @ApiModelProperty("关联备注")
  private String associateRemark;
  @ApiModelProperty("扫描发票图片路径")
  private String scanImageUrl;
  @ApiModelProperty("扫描时间")
  private Date scanTime;
  @ApiModelProperty("影像上传时间")
  private Date imageUploadTime;
  @ApiModelProperty("签收时间")
  private Date receiptTime;
  @ApiModelProperty("认证时间")
  private Date identifyTime;
  @ApiModelProperty("勾选时间")
  private Date checkTime;
  @ApiModelProperty("退票时间")
  private Date retreatTime;
  @ApiModelProperty("审核时间")
  private Date approveTime;
  @ApiModelProperty("付款时间")
  private Date paymentTime;
  @ApiModelProperty("物流单号")
  private String parcelNo;
  @ApiModelProperty("物流公司代码")
  private String expressCode;
  @ApiModelProperty("税款所属期")
  private String authTaxPeriod;
  @JsonProperty("invoiceDetails")
  private List<InvoiceItem> invoiceDetails = new ArrayList<InvoiceItem>();
  @JsonProperty("invoiceVehicleInfo")
  private SellerInvoiceVehicleInfo invoiceVehicleInfo = null;
}
