package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import lombok.Builder;

import java.util.ArrayList;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 发票列表
 */
@ApiModel(description = "发票列表")

@JsonInclude(NON_NULL)
@Builder
public class InvoiceWithDetailsData {
  @JsonProperty("invoiceList")
  private List<InvoiceWithDetails> invoiceList = new ArrayList<>();

  public List<InvoiceWithDetails> getInvoiceList() {
    return invoiceList;
  }

  public void setInvoiceList(List<InvoiceWithDetails> invoiceList) {
    this.invoiceList = invoiceList;
  }
}
