package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 文件信息
 */
@JsonInclude(NON_NULL)
public class MsFileInfo {
	@JsonProperty("fileDirectory")
	private String fileDirectory;
	@JsonProperty("originFileName")
	private String originFileName;
	@JsonProperty("uploadFileName")
	private String uploadFileName;
	@JsonProperty("fileBaseUrl")
	private String fileBaseUrl;
	@JsonProperty("fileSize")
	private Integer fileSize;
	@JsonProperty("url")
	private String url;

	public String getFileBaseUrl() {
		return fileBaseUrl;
	}

	public void setFileBaseUrl(String fileBaseUrl) {
		this.fileBaseUrl = fileBaseUrl;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getFileDirectory() {
		return fileDirectory;
	}

	public void setFileDirectory(String fileDirectory) {
		this.fileDirectory = fileDirectory;
	}

	public String getOriginFileName() {
		return originFileName;
	}

	public void setOriginFileName(String originFileName) {
		this.originFileName = originFileName;
	}

	public String getUploadFileName() {
		return uploadFileName;
	}

	public void setUploadFileName(String uploadFileName) {
		this.uploadFileName = uploadFileName;
	}

	public Integer getFileSize() {
		return fileSize;
	}

	public void setFileSize(Integer fileSize) {
		this.fileSize = fileSize;
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("class FileInfo {\n");

		sb.append("    fileDirectory: ").append(toIndentedString(fileDirectory)).append("\n");
		sb.append("    originFileName: ").append(toIndentedString(originFileName)).append("\n");
		sb.append("    uploadFileName: ").append(toIndentedString(uploadFileName)).append("\n");
		sb.append("    fileSize: ").append(toIndentedString(fileSize)).append("\n");
		sb.append("}");
		return sb.toString();
	}

	/**
	 * Convert the given object to string with each line indented by 4 spaces
	 * (except the first line).
	 */
	private String toIndentedString(Object o) {
		if (o == null) {
			return "null";
		}
		return o.toString().replace("\n", "\n    ");
	}

}
