package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.xforceplus.xplatframework.apimodel.PollingModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 作废发票轮询结果对象
 */
@ApiModel(description = "作废发票轮询结果对象")

@JsonInclude(NON_NULL)
public class PollingAbandonInvoiceResult extends PollingModel {

    @ApiModelProperty(value = "作废发票失败总数")
    private int failedCount = 0;
    @ApiModelProperty(value = "作废发票成功总数")
    private int successCount = 0;

    private List<AbandonInvoiceCheckInfo>  abandonInfos;


    public int getFailedCount() {
        return failedCount;
    }

    public void setFailedCount(int failedCount) {
        this.failedCount = failedCount;
    }

    public int getSuccessCount() {
        return successCount;
    }

    public void setSuccessCount(int successCount) {
        this.successCount = successCount;
    }

    public List<AbandonInvoiceCheckInfo> getAbandonInfos() {
        return abandonInfos;
    }

    public void setAbandonInfos(List<AbandonInvoiceCheckInfo> abandonInfos) {
        this.abandonInfos = abandonInfos;
    }

    @Override
    public String toString() {
        return "PollingAbandonInvoiceResult{" +
                "failedCount=" + failedCount + "successCount" + successCount +
                "} " + super.toString();
    }
}
