package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * @author <a href="mail to: libaozhong@xforceplus.com" rel="nofollow">libaozhong</a>
 * @Description: [功能描述]
 * @version: 1.0
 * @CreateDate: 2019-07-02 15:21</p>
 */

@ApiModel(description = "预制发票回填信息")
@JsonInclude(NON_NULL)
@Data
public class PreInvoiceBackFillRequest {
    @ApiModelProperty(value = "租户Id",required = true)
    private Long sellerGroupId;
    @ApiModelProperty(value = "预制发票id",required = true)
    private Long preInvoiceId;
    @ApiModelProperty(value = "开票日期",required = true)
    private  String paperDrewDate;
    @ApiModelProperty(value = "发票代码")
    private  String invoiceCode;
    @ApiModelProperty(value = "发票号码",required = true)
    private   String invoiceNo;

    @ApiModelProperty(value = "数电发票号码")
    private String allElectricInvoiceNo;
    @ApiModelProperty(value = "密文",required = true)
    private String cipherText;
    @ApiModelProperty(value = "pdf地址",required = true)
    private String pdfUrl;
    @ApiModelProperty(value = "ofd地址",required = true)
    private String ofdUrl;
    @ApiModelProperty(value = "xml地址",required = true)
    private String xmlUrl;

    @ApiModelProperty(value = "校验码",required = true)
    private String checkCode;
    @ApiModelProperty(value = "机器码",required = true)
    private String machineCode;
    @ApiModelProperty(value = "开票人",required = true)
    private String invoicerName;
    @ApiModelProperty(value = "原发票号码",required = true)
    private String originInvoiceNo;
    @ApiModelProperty(value = "原发票代码",required = true)
    private String originInvoiceCode;
    @ApiModelProperty(value = "红字信息表编号",required = true)
    private String redNotificationNo;
}
