package com.xforceplus.seller.invoice.client.model;

/**
 * 与第三方系统操作类型
 */
public enum PreInvoiceReleaseType {

    /**
     * 释放预制发票
     */
    RELEASE( 1, "释放预制发票"),

    /**
     * 释放业务单
     */
    RELEASE_BILL(2, "释放业务单"),

    /**
     * 不释放预制发票
     */
    NOT_RELEASE(3, "不释放预制发票或业务单"),

    /**
     * 释放业务单 但是 不释放 明细（抽取已匹配业务单的发票 释放情况）
     */
    RELEASE_BILL_NOT_ITEM(4, "释放业务单"),
    ;


    private int value;

    private String description;

    public Integer value() {
        return value;
    }

    public String description(){
        return this.description;
    }

    PreInvoiceReleaseType(int value, String description) {
        this.value = value;
        this.description = description;
    }

    public static PreInvoiceReleaseType fromValue(String value){
        for (PreInvoiceReleaseType operationType : PreInvoiceReleaseType.values()) {
            if (operationType.value().toString().equals(value)) {
                return operationType;
            }
        }
        if("5".equals(value)){
            return PreInvoiceReleaseType.RELEASE;
        }
        return PreInvoiceReleaseType.NOT_RELEASE;
    }

    public static PreInvoiceReleaseType fromValue(int value) {
        for (PreInvoiceReleaseType operationType : PreInvoiceReleaseType.values()) {
            if (operationType.value == value) {
                return operationType;
            }
        }
        if (value == 5) {
            return PreInvoiceReleaseType.RELEASE;
        }

        if(value == 6) {
            return PreInvoiceReleaseType.RELEASE;
        }
        return PreInvoiceReleaseType.NOT_RELEASE;
    }

}
