package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * PreviewInvoiceResponse
 */

@JsonInclude(NON_NULL)
public class PreviewInvoiceListResponse {
  @JsonProperty("code")
  private Integer code = 1;

  @JsonProperty("message")
  private String message = "获取成功!";

  @JsonProperty("result")
  private List<PreInvoice> result = null;

  @JsonIgnore
  public PreviewInvoiceListResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * Get code
   * @return code
  **/
  @ApiModelProperty(value = "")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public PreviewInvoiceListResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * Get message
   * @return message
  **/
  @ApiModelProperty(value = "")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public PreviewInvoiceListResponse result(List<PreInvoice> result) {
    this.result = result;
    return this;
  }

   /**
   * 预制发票主信息
   * @return result
  **/
  @ApiModelProperty(value = "预制发票主信息")
  public List<PreInvoice> getResult() {
    return result;
  }

  public void setResult(List<PreInvoice> result) {
    this.result = result;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PreviewInvoiceListResponse previewInvoiceResponse = (PreviewInvoiceListResponse) o;
    return Objects.equals(this.code, previewInvoiceResponse.code) &&
        Objects.equals(this.message, previewInvoiceResponse.message) &&
        Objects.equals(this.result, previewInvoiceResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PreviewInvoiceResponse {\n");

    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
