package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * QueryBillDetailsRequest
 */

@JsonInclude(NON_NULL)
public class QueryBillDetailsRequest {
  @JsonProperty("billId")
  private Long billId = null;

  @JsonProperty("pageNo")
  private Integer pageNo = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonIgnore
  public QueryBillDetailsRequest billId(Long billId) {
    this.billId = billId;
    return this;
  }

   /**
   * 发票id
   * @return billId
  **/
  @ApiModelProperty(value = "发票id")
  public Long getBillId() {
    return billId;
  }

  public void setBillId(Long billId) {
    this.billId = billId;
  }

  @JsonIgnore
  public QueryBillDetailsRequest pageNo(Integer pageNo) {
    this.pageNo = pageNo;
    return this;
  }

   /**
   * 页码
   * @return pageNo
  **/
  @ApiModelProperty(value = "页码")
  public Integer getPageNo() {
    return pageNo;
  }

  public void setPageNo(Integer pageNo) {
    this.pageNo = pageNo;
  }

  @JsonIgnore
  public QueryBillDetailsRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 每页数据量
   * @return pageSize
  **/
  @ApiModelProperty(value = "每页数据量")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QueryBillDetailsRequest queryBillDetailsRequest = (QueryBillDetailsRequest) o;
    return Objects.equals(this.billId, queryBillDetailsRequest.billId) &&
        Objects.equals(this.pageNo, queryBillDetailsRequest.pageNo) &&
        Objects.equals(this.pageSize, queryBillDetailsRequest.pageSize);
  }

  @Override
  public int hashCode() {
    return Objects.hash(billId, pageNo, pageSize);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueryBillDetailsRequest {\n");

    sb.append("    billId: ").append(toIndentedString(billId)).append("\n");
    sb.append("    pageNo: ").append(toIndentedString(pageNo)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
