package com.xforceplus.seller.invoice.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import lombok.Data;

/**
 * SellerStatisticsQueryByConditionRequest
 */

@JsonInclude(NON_NULL)
@Data
public class SellerStatisticsQueryByConditionRequest {
  @JsonProperty("pageNo")
  private Integer pageNo = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

  private String taxNo;

  private Boolean quarterlyOverrun;

  private Boolean annualOverrun;

  @ApiModelProperty("季度开票金额范围查询")
  private List<BigDecimal> quarterlyScope;

  @ApiModelProperty("年度开票金额范围查询")
  private List<BigDecimal> annualScope;

  @JsonProperty("sort")
  private Sort sort = null;

}
