package com.xforceplus.seller.invoice.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;


@ApiModel(description = "智能匹配查询返回结果信息")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SmartMatchInvoiceResult {

    @ApiModelProperty("预制发票或单据明细合并后明细和原明细关系Map")
    private Map<Long,List<ItemIdToAmountInfo>> mergedItemRelationMap = Maps.newHashMap();

    @ApiModelProperty("红冲原因")
    private String makingReason;

    @ApiModelProperty("发票匹配列表")
    private List<SmartMatchedInvoice> invoiceMatchList;

    @ApiModelProperty("智能匹配组合列表")
    private List<SmartMatchedInvoiceGroup> invoiceSmartMatchGroupList;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class SmartMatchedInvoice implements Serializable {
        @ApiModelProperty("发票id")
        private Long id;
//        @ApiModelProperty("预制发票Id")
//        private Long preInvoiceId;
        @ApiModelProperty("销方租户Id")
        private Long sellerGroupId;
        @ApiModelProperty("销方名称")
        private String sellerName;
        @ApiModelProperty("购方名称")
        private String purchaserName;
        @ApiModelProperty("购方租户Id")
        private Long purchaserGroupId;
        @ApiModelProperty("发票号码")
        private String invoiceNo;
        @ApiModelProperty("发票代码")
        private String invoiceCode;
        @ApiModelProperty("数电发票号码")
        private String allElectricInvoiceNo;
        @ApiModelProperty("国税发票来源")
        private String taxInvoiceSource;
        @ApiModelProperty("开票日期")
        private Date paperDrawDate;
        @ApiModelProperty("发票类型")
        private String invoiceType;
        @ApiModelProperty("红冲状态 0 - 正常  1-待红冲  2-待部分红冲 3-已红冲 4-已部分红冲 5-红冲票 10-不可申请红字信息表 ")
        private String redFlag;
        @ApiModelProperty("税额")
        private String taxAmount;
        @ApiModelProperty("不含税金额")
        private String amountWithoutTax;
        @ApiModelProperty("含税金额")
        private String amountWithTax;
        @ApiModelProperty("特殊发票标记  0-默认  1-通行费   2-成品油 3-区块链发票 4-机动车专票 ")
        private Integer specialInvoiceFlag;
        @ApiModelProperty("认证状态 0-默认 1-不可认证 2-未认证 3-认证中 4-认证成功 5-认证失败 6-认证异常 7-已转出")
        private String identifyStatus;
        @ApiModelProperty("匹配度")
        private BigDecimal matchingDegree;

        @ApiModelProperty("合并后明细和原明细关系Map")
        private Map<Long, List<ItemIdToAmountInfo>> mergedInvoiceItemRelationMap = Maps.newHashMap();

        @ApiModelProperty("匹配单据明细和发票明细存在关联性")
        private List<InvoiceItemIdWithBillItemIdRelationData> targetItemRelationList = Lists.newArrayList();

        @ApiModelProperty("匹配单据明细和发票明细存在关联性")
        private List<InvoiceItemIdWithBillItemIdRelationData> sourceItemRelationList = Lists.newArrayList();
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class SmartMatchedInvoiceGroup implements Serializable {
        @ApiModelProperty("组合编号")
        private Integer groupNo;
        @ApiModelProperty("发票匹配列表")
        private List<SmartMatchedInvoice> invoiceMatchList;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class MatchingBillItem implements Serializable {
        @ApiModelProperty("单据Id")
        private Long billId;
        @ApiModelProperty("明细Id")
        private Long billItemId;
        @ApiModelProperty("商品名称")
        private String itemName;
//        @ApiModelProperty("简称")
//        private String itemShortName;
//        @ApiModelProperty("货物名称 格式：*简称*商品名称")
//        private String cargoName;
        @ApiModelProperty("计价方式")
        private Integer priceMethod;
        @ApiModelProperty("不含税单价")
        private BigDecimal unitPrice;
        @ApiModelProperty("含税单价")
        private BigDecimal unitPriceWithTax;
        @ApiModelProperty("含税金额")
        private BigDecimal amountWithTax;
        @ApiModelProperty("不含税金额")
        private BigDecimal amountWithoutTax;
        @ApiModelProperty("税额")
        private BigDecimal taxAmount;
        @ApiModelProperty("数量")
        private BigDecimal quantity;
        @ApiModelProperty("数量单位")
        private String quantityUnit;
        @ApiModelProperty("税收分类编码")
        private String goodsTaxNo;
        @ApiModelProperty("规格型号")
        private String itemSpec;
        @ApiModelProperty("税率")
        private BigDecimal taxRate;
        @ApiModelProperty("是否享受税收优惠政策0-不1-享受")
        private String taxPre;
        @ApiModelProperty("享受税收优惠政策内容 0-不 1-享受")
        private String taxPreCon;
        @ApiModelProperty("零税率标志空-非0税率；0-出口退税1-免税2-不征税3-普通0税率")
        private String zeroTax;
        @ApiModelProperty("税编转换代码")
        private String taxConvertCode;
        @ApiModelProperty("编码版本号")
        private String goodsNoVer;
        @ApiModelProperty("大类名称")
        private String largeCategoryName;
        @ApiModelProperty("中类名称")
        private String medianCategoryName;
        @ApiModelProperty("小类名称")
        private String smallCategoryName;
        @ApiModelProperty("明细项特殊处理字段，SI:销项,RI:退项,PA:正调整单,MA:负调整单")
        private String specialItemType;
        @ApiModelProperty("是否合并过 true:合并过, false:未合并")
        private Boolean isMerged = false;
        @ApiModelProperty("合并后明细和原明细关系Map")
        private Map<Long,List<ItemIdToAmountInfo>> billItemRelationMap = Maps.newHashMap();
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class ItemIdToAmountInfo implements Serializable {
        @ApiModelProperty("原明细Id")
        private Long sourceItemId;
        @ApiModelProperty("原明细金额")
        private BigDecimal amount;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class MatchingInvoiceItem implements Serializable {
        @ApiModelProperty("发票Id")
        private Long invoiceId;
        @ApiModelProperty("明细Id")
        private Long invoiceItemId;
        @ApiModelProperty("货物Code")
        private String cargoCode;

//        @ApiModelProperty("货物名称")
//        private String cargoName;

        @ApiModelProperty("itemName")
        private String itemName;

        @ApiModelProperty("税收分类编码")
        private String goodsTaxNo;
        @ApiModelProperty("规格型号")
        private String itemSpec;
        @ApiModelProperty("税率")
        private BigDecimal taxRate;

        @ApiModelProperty("不含税单价")
        private BigDecimal unitPrice;
        @ApiModelProperty("不含税金额")
        private BigDecimal amountWithTax;
        @ApiModelProperty("含税金额")
        private BigDecimal amountWithoutTax;
        @ApiModelProperty("税额")
        private BigDecimal taxAmount;
        @ApiModelProperty("数量")
        private BigDecimal quantity;
        @ApiModelProperty("数量单位")
        private String quantityUnit;

        @ApiModelProperty("已红冲数量")
        private BigDecimal positiveQuantity;
        @ApiModelProperty("已红冲含税金额")
        private BigDecimal positiveAmountWithTax;
        @ApiModelProperty("已红冲不含税金额")
        private BigDecimal positiveAmountWithoutTax;
        @ApiModelProperty("已红冲税额")
        private BigDecimal positiveTaxAmount;

        @ApiModelProperty("剩余可红冲数量")
        private BigDecimal residueQuantity;
        @ApiModelProperty("剩余可红冲含税金额")
        private BigDecimal residueAmountWithTax;
        @ApiModelProperty("剩余可红冲不含税金额")
        private BigDecimal residueAmountWithoutTax;
        @ApiModelProperty("剩余可红冲税额")
        private BigDecimal residueTaxAmount;

        @ApiModelProperty("单据Id")
        private Long billId;
        @ApiModelProperty("单据ItemId")
        private Long billItemId;
        @ApiModelProperty("行匹配得分")
        private BigDecimal matchingScore = BigDecimal.ZERO;
        @ApiModelProperty("行总分")
        private BigDecimal totalScore = BigDecimal.ZERO;
        @ApiModelProperty("行匹配度")
        private BigDecimal matchingDegree = BigDecimal.ZERO;

        @ApiModelProperty("含税单价")
        private BigDecimal unitPriceWithTax;
        public BigDecimal getUnitPriceWithTax() {
            if(BigDecimal.ZERO.compareTo( Optional.ofNullable(this.residueQuantity).orElse(BigDecimal.ZERO)) == 0) {
                return residueAmountWithTax;
            }
            return residueAmountWithTax.divide(residueQuantity, 2, RoundingMode.HALF_UP);
        }
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class InvoiceItemIdWithBillItemIdRelationData implements Serializable {
        @ApiModelProperty("合并后（或原）单据、预制发票明细ItemId")
        private Long itemId;
        @ApiModelProperty("合并后（或原）发票明细ItemId")
        private Long invoiceItemId;
        @ApiModelProperty("匹配的发票明细金额")
        private BigDecimal matchedAmount;
    }
}
