package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class UpdateInvoiceItemPreReverseAmountRequest implements Serializable {
    @ApiModelProperty("操作类型 1-增加 2-减少")
    private Integer operationType;
    private List<InvoiceAmountInfo> invoiceList;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class InvoiceAmountInfo implements Serializable {
        @JsonFormat(shape = JsonFormat.Shape.STRING)
        private Long invoiceId;
        private List<ItemAmountInfo> itemList;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class ItemAmountInfo implements Serializable {
        private Integer rowNum;
        @JsonFormat(shape = JsonFormat.Shape.STRING)
        private Long itemId;
        private BigDecimal quantity;
        private BigDecimal amountWithoutTax;
        private BigDecimal taxAmount;
        private BigDecimal amountWithTax;
    }
}
