package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;


/**
 * PreInvoicePageInfo
 */

@Data
public class UpdatePreInvoiceByIdsRequest {
  @JsonProperty("preInvoiceIds")
  private List<Long> preInvoiceIds;

  /**
   * 发票类型
   * 表 : inv_seller_pre_invoice
   * 对应字段 : invoice_type
   */
  @JsonProperty("invoiceType")
  private String invoiceType;

  /**
   * 发票票种
   * 表 : inv_seller_pre_invoice
   * 对应字段 : invoice_type
   */
  @JsonProperty("invoiceKind")
  private String invoiceKind;

  /**
   * 单据号
   */
  @JsonProperty("salesbillNo")
  private String salesbillNo;

  /**
   * 预制发票状态，0=删除，1=待确认,2=有变更,3=购方确认中(销方待确认),4=销方确认中(购方待确认),5=待开票,6=开票中,7已开票
   * 表 : inv_seller_pre_invoice
   * 对应字段 : status
   */
  @JsonProperty("status")
  private Integer status;


  /**
   * 购方名称
   * 表 : inv_seller_pre_invoice
   * 对应字段 : purchaser_name
   */
  @JsonProperty("purchaserName")
  private String purchaserName;

  /**
   * 购方税号
   * 表 : inv_seller_pre_invoice
   * 对应字段 : purchaser_tax_no
   */
  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo;

  /**
   * 购方电话
   * 表 : inv_seller_pre_invoice
   * 对应字段 : purchaser_tel
   */
  @JsonProperty("purchaserTel")
  private String purchaserTel;

  /**
   * 购方地址
   * 表 : inv_seller_pre_invoice
   * 对应字段 : purchaser_address
   */
  @JsonProperty("purchaserAddress")
  private String purchaserAddress;

  /**
   * 购方开户行
   * 表 : inv_seller_pre_invoice
   * 对应字段 : purchaser_bank_name
   */
  @JsonProperty("purchaserBankName")
  private String purchaserBankName;

  /**
   * 购方银行账号
   * 表 : inv_seller_pre_invoice
   * 对应字段 : purchaser_bank_account
   */
  @JsonProperty("purchaserBankAccount")
  private String purchaserBankAccount;

  /**
   * 销方税号
   * 表 : inv_seller_pre_invoice
   * 对应字段 : seller_tax_no
   */
  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * 销方名称
   * 表 : inv_seller_pre_invoice
   * 对应字段 : seller_name
   */
  @JsonProperty("sellerName")
  private String sellerName;

  /**
   * 销方电话
   * 表 : inv_seller_pre_invoice
   * 对应字段 : seller_tel
   */
  @JsonProperty("sellerTel")
  private String sellerTel;

  /**
   * 销方地址
   * 表 : inv_seller_pre_invoice
   * 对应字段 : seller_address
   */
  @JsonProperty("sellerAddress")
  private String sellerAddress;

  /**
   * 销方开户行
   * 表 : inv_seller_pre_invoice
   * 对应字段 : seller_bank_name
   */
  @JsonProperty("sellerBankName")
  private String sellerBankName;

  /**
   * 销方银行账号
   * 表 : inv_seller_pre_invoice
   * 对应字段 : seller_bank_account
   */
  @JsonProperty("sellerBankAccount")
  private String sellerBankAccount;

  /**
   * 开票人
   */
  @JsonProperty("invoicerName")
  private String invoicerName;

  /**
   * 复核人
   */
  @JsonProperty("checkerName")
  private String checkerName;

  /**
   * 收款人
   */
  @JsonProperty("cashierName")
  private String cashierName;

  /**
   * 来源
   */
  @JsonProperty("requestSource")
  private String requestSource;

  @JsonProperty("ext1")
  private String ext1;

  @JsonProperty("ext2")
  private String ext2;

  @JsonProperty("ext3")
  private String ext3;

  @JsonProperty("ext4")
  private String ext4;

  @JsonProperty("ext5")
  private String ext5;

  @JsonProperty("ext6")
  private String ext6;

  @JsonProperty("ext7")
  private String ext7;

  @JsonProperty("ext8")
  private String ext8;

  @JsonProperty("ext9")
  private String ext9;

  @JsonProperty("ext10")
  private String ext10;

  @JsonProperty("ext11")
  private String ext11;

  @JsonProperty("ext12")
  private String ext12;

  @JsonProperty("ext13")
  private String ext13;

  @JsonProperty("ext14")
  private String ext14;

  @JsonProperty("ext15")
  private String ext15;

  @JsonProperty("ext16")
  private String ext16;

  @JsonProperty("ext17")
  private String ext17;

  @JsonProperty("ext18")
  private String ext18;

  @JsonProperty("ext19")
  private String ext19;

  @JsonProperty("ext20")
  private String ext20;

  @JsonProperty("ext21")
  private String ext21;

  @JsonProperty("ext22")
  private String ext22;

  @JsonProperty("ext23")
  private String ext23;

  @JsonProperty("ext24")
  private String ext24;

  @JsonProperty("ext25")
  private String ext25;

  private Integer redNotificationFlag;

  private Integer purchaserType;

  private String receiveUserEmail;

  private String receiveUserTel;

}
