package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 预制删除发票请求参数
 */
@ApiModel(description = "预制发票请求参数")

@JsonInclude(NON_NULL)
@Data
public class UpdatePreInvoiceItemsRequest extends  PreInvoiceRequest {

    @JsonProperty("id")
    @ApiModelProperty(value = "预制发票明细id")
    private List<Long> id;

    @ApiModelProperty(value = "修改标记")
    @JsonProperty("modifyMark")
    private Long modifyMark;

    @ApiModelProperty(value = "税收分类编码")
    @JsonProperty("goodsTaxNo")
    private String goodsTaxNo;

    @ApiModelProperty(value = "商品名称")
    @JsonProperty("cargoName")
    private String cargoName;

    @ApiModelProperty(value = "商品代码")
    @JsonProperty("cargoCode")
    private String cargoCode;

    @ApiModelProperty(value = "规格型号")
    @JsonProperty("itemSpec")
    private String itemSpec;

    @ApiModelProperty(value = "单位")
    @JsonProperty("quantityUnit")
    private String quantityUnit;

    @ApiModelProperty(value = "税编版本号")
    @JsonProperty("goodsNoVer")
    private String goodsNoVer;

    @ApiModelProperty(value = "是否享受优惠政策")
    @JsonProperty("taxPre")
    private String taxPre;

    @ApiModelProperty(value = "享受优惠政策内容")
    @JsonProperty("taxPreCon")
    private String taxPreCon;

    @ApiModelProperty(value = "零税率标识")
    @JsonProperty("zeroTax")
    private String zeroTax;

    @ApiModelProperty(value = "扣除额")
    @JsonProperty("deduction")
    private String deduction;

    @ApiModelProperty(value = "折扣行标识")
    @JsonProperty("discountFlag")
    private String discountFlag;

    @ApiModelProperty(value = "价格方式")
    @JsonProperty("priceMethod")
    private String priceMethod;

    @ApiModelProperty(value = "是否打印单价数量")
    @JsonProperty("printContentFlag")
    private String printContentFlag;

    @ApiModelProperty(value = "浮动金额(调整的容差金额)")
    @JsonProperty("floatingAmount")
    private String floatingAmount;

    @ApiModelProperty(value = "商品税目")
    @JsonProperty("taxItem")
    private String taxItem;
}


