package com.xforceplus.seller.invoice.client.model;

import java.math.BigDecimal;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * 小规模纳税人配置变更实体
 *
 * @author adnis
 */
@Data
public class WarningConfigMessage {

    @NotNull(message = "租户ID不能为空")
    private Long tenantId;

    @NotNull(message = "公司名称不能为空")
    private String companyName;

    @NotNull(message = "公司税号不能为空")
    private String taxNo;

    @NotNull(message = "类型不能为空")
    private String type;

    @NotNull(message = "限额不能为空")
    private BigDecimal warnAmount;

    @NotNull(message = "状态不能为空")
    private String status;

    @NotNull(message = "操作不能为空")
    private String operation;

}