package com.xforceplus.seller.invoice.client.model.adapter;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@ApiModel(description = "响应")
@JsonInclude(NON_NULL)
@Data
public class MakeOutResponse {

    @JsonProperty("data")
    @ApiModelProperty(value = "发票信息")
    private Object date;

    @JsonProperty("status")
    @ApiModelProperty(value = "状态")
    private Integer status;

    @JsonProperty("serialNo")
    @ApiModelProperty(value = "流水号")
    private String serialNo;

    @JsonProperty("settlementNo")
    @ApiModelProperty(value = "结算单号")
    private String settlementNo;

    @JsonProperty("resultType")
    @ApiModelProperty(value = "操作类型")
    private String resultType;

}
