package com.xforceplus.seller.invoice.client.model.adapter;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;

import java.io.Serializable;
import java.math.BigDecimal;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@ApiModel(description = "销方表对象明细")
@SuppressWarnings({"all", "unchecked", "rawtypes"})
@JsonInclude(NON_NULL)
public class SellerInvoiceItem implements Serializable {

    @JsonProperty("pid")
    private String pid = null;

    @JsonProperty("cargoCode")
    private String cargoCode = null;

    @JsonProperty("cargoName")
    private String cargoName = null;

    @JsonProperty("itemSpec")
    private String itemSpec = null;

    @JsonProperty("quantityUnit")
    private String quantityUnit = null;

    @JsonProperty("quantity")
    private BigDecimal quantity = null;

    @JsonProperty("taxRate")
    private BigDecimal taxRate = null;

    @JsonProperty("unitPrice")
    private BigDecimal unitPrice = null;

    @JsonProperty("amountWithoutTax")
    private BigDecimal amountWithoutTax = null;

    @JsonProperty("taxAmount")
    private BigDecimal taxAmount = null;

    @JsonProperty("amountWithTax")
    private BigDecimal amountWithTax = null;

    @JsonProperty("discountWithoutTax")
    private BigDecimal discountWithoutTax = null;

    @JsonProperty("discountTax")
    private BigDecimal discountTax = null;

    @JsonProperty("discountWithTax")
    private BigDecimal discountWithTax = null;

    @JsonProperty("discountRate")
    private BigDecimal discountRate = null;

    @JsonProperty("goodsNoVer")
    private String goodsNoVer = null;

    @JsonProperty("goodsTaxNo")
    private String goodsTaxNo = null;

    @JsonProperty("taxPre")
    private String taxPre = null;

    @JsonProperty("taxPreCon")
    private String taxPreCon = null;

    @JsonProperty("zeroTax")
    private String zeroTax = null;

    @JsonProperty("taxDedunction")
    private BigDecimal taxDedunction = null;

    @JsonProperty("remark")
    private String remark = null;
    
    @JsonProperty("orderNo")
    private String orderNo = null;
    
    @JsonProperty("orderDetailNo")
    private String orderDetailNo = null;


    public SellerInvoiceItem(){

    }

    public String getPid() {
        return pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getItemSpec() {
        return itemSpec;
    }

    public void setItemSpec(String itemSpec) {
        this.itemSpec = itemSpec;
    }

    public String getQuantityUnit() {
        return quantityUnit;
    }

    public void setQuantityUnit(String quantityUnit) {
        this.quantityUnit = quantityUnit;
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    public BigDecimal getDiscountWithoutTax() {
        return discountWithoutTax;
    }

    public void setDiscountWithoutTax(BigDecimal discountWithoutTax) {
        this.discountWithoutTax = discountWithoutTax;
    }

    public BigDecimal getDiscountTax() {
        return discountTax;
    }

    public void setDiscountTax(BigDecimal discountTax) {
        this.discountTax = discountTax;
    }

    public BigDecimal getDiscountWithTax() {
        return discountWithTax;
    }

    public void setDiscountWithTax(BigDecimal discountWithTax) {
        this.discountWithTax = discountWithTax;
    }

    public BigDecimal getDiscountRate() {
        return discountRate;
    }

    public void setDiscountRate(BigDecimal discountRate) {
        this.discountRate = discountRate;
    }

    public String getGoodsNoVer() {
        return goodsNoVer;
    }

    public void setGoodsNoVer(String goodsNoVer) {
        this.goodsNoVer = goodsNoVer;
    }

    public String getGoodsTaxNo() {
        return goodsTaxNo;
    }

    public void setGoodsTaxNo(String goodsTaxNo) {
        this.goodsTaxNo = goodsTaxNo;
    }

    public String getTaxPre() {
        return taxPre;
    }

    public void setTaxPre(String taxPre) {
        this.taxPre = taxPre;
    }

    public String getTaxPreCon() {
        return taxPreCon;
    }

    public void setTaxPreCon(String taxPreCon) {
        this.taxPreCon = taxPreCon;
    }

    public String getZeroTax() {
        return zeroTax;
    }

    public void setZeroTax(String zeroTax) {
        this.zeroTax = zeroTax;
    }

    public BigDecimal getTaxDedunction() {
        return taxDedunction;
    }

    public void setTaxDedunction(BigDecimal taxDedunction) {
        this.taxDedunction = taxDedunction;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

	public String getOrderNo() {
		return orderNo;
	}

	public void setOrderNo(String orderNo) {
		this.orderNo = orderNo;
	}

	public String getOrderDetailNo() {
		return orderDetailNo;
	}

	public void setOrderDetailNo(String orderDetailNo) {
		this.orderDetailNo = orderDetailNo;
	}
}
