package com.xforceplus.seller.invoice.client.model.open;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("分页信息")
public class PageInfo {
    @ApiModelProperty("页码")
    private Integer pageNo;
    @ApiModelProperty("页大小")
    private Integer pageSize;
    @ApiModelProperty("总数")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long total;
}
