package com.xforceplus.seller.invoice.client.model.open;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("销项预制发票查询结果")
public class SellerPreInvoiceDto {
    @ApiModelProperty("预制发票id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long preInvoiceId;
    @ApiModelProperty("批次号")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long batchNo;
    @ApiModelProperty("状态")
    private Integer status;
    @ApiModelProperty("发票类型")
    private String invoiceType;
    @ApiModelProperty("备注")
    private String remark;
    @ApiModelProperty("开票日期")
    private String dateIssued;
    @ApiModelProperty("发票号码")
    private String invoiceNo;
    @ApiModelProperty("发票代码")
    private String invoiceCode;
    @ApiModelProperty("金额信息")
    private InvoiceAmount amount;
    @ApiModelProperty("销方信息")
    private QuerySeller seller;
    @ApiModelProperty("购方信息")
    private QueryBuyer buyer;
    @ApiModelProperty("红字信息")
    private RedLetter redLetter;
    @ApiModelProperty("打印信息")
    private Print print;
    @ApiModelProperty("业务信息")
    private PreInvoiceBusinessAttrs businessAttrs;
    @ApiModelProperty("经办人信息")
    private OperatorInfo operator;
    @ApiModelProperty("扩展信息")
    private ExtendedAttrs extendedAttrs;
    @ApiModelProperty("明细信息")
    private List<SellerPreInvoiceItemDto> details;
}
