package com.xforceplus.seller.invoice.client.model.open;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("销项预制发票明细查询结果")
public class SellerPreInvoiceItemDto {
    //TODO 这个id是什么
    @ApiModelProperty("发票id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long id;
    @ApiModelProperty("业务单明细id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long bizOrderDetailId;
    @ApiModelProperty("业务单明细号")
    private String bizOrderDetailNo;
    @ApiModelProperty("预制发票id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long preInvoiceId;
    @ApiModelProperty("预制发票明细id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long preInvoiceDetailId;
    @ApiModelProperty("货物&应税劳务、服务代码")
    private String itemCode;
    @ApiModelProperty("货物&应税劳务、服务名称")
    private String itemName;
    @ApiModelProperty("规格型号")
    private String specifications;
    @ApiModelProperty("数量单位")
    private String unit;
    @ApiModelProperty("税率")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal taxRate;
    @ApiModelProperty("商品税目")
    private String taxItem;
//    private String goodsTaxNo;
//    private String goodsNoVer;
    @ApiModelProperty("优惠信息")
    private RedLetterDetailTax detailTax;
    @ApiModelProperty("明细扩展信息")
    private DetailExtendedAttrs detailExtendedAttrs;
    @ApiModelProperty("明细折扣金额信息")
    private DetailDiscount detailDiscount;
    @ApiModelProperty("明细金额信息")
    private DetailAmount detailAmount;
}
