package com.xforceplus.seller.invoice.clientl.v2.mode;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

@ApiModel(
    description = "金额信息"
)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class InvoiceAmountInfo {
    @JsonProperty("amountWithTax")
    private String amountWithTax;
    @JsonProperty("amountWithoutTax")
    private String amountWithoutTax;
    @JsonProperty("taxAmount")
    private String taxAmount;

    public InvoiceAmountInfo(String amountWithTax, String amountWithoutTax, String taxAmount) {
        this.amountWithTax = amountWithTax;
        this.amountWithoutTax = amountWithoutTax;
        this.taxAmount = taxAmount;
    }

    public InvoiceAmountInfo() {
    }

    @ApiModelProperty("含税金额（保留小数点后2位）")
    public String getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(String amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    @ApiModelProperty("不含税金额（保留小数点后2位）")
    public String getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(String amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    @ApiModelProperty("税额（保留小数点后2位）")
    public String getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(String taxAmount) {
        this.taxAmount = taxAmount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        InvoiceAmountInfo that = (InvoiceAmountInfo) o;
        return Objects.equals(amountWithTax, that.amountWithTax) &&
                Objects.equals(amountWithoutTax, that.amountWithoutTax) &&
                Objects.equals(taxAmount, that.taxAmount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(amountWithTax, amountWithoutTax, taxAmount);
    }

    @Override
    public String toString() {
        return "AutoPdfInvoiceAmountInfo{" +
                "amountWithTax='" + amountWithTax + '\'' +
                ", amountWithoutTax='" + amountWithoutTax + '\'' +
                ", taxAmount='" + taxAmount + '\'' +
                '}';
    }
    private String toIndentedString(Object o) {
        return o == null ? "null" : o.toString().replace("\n", "\n    ");
    }

}
