package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.*;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "invoice", description = "the invoice API")
public interface InvoiceExportApi {



    @ApiOperation(value = "由查询条件获取searchModel", notes = "", response = SearchModelResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "Export", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = SearchModelResponse.class) })
    @RequestMapping(value = "/export/getSearchModelResponse",
            produces = { "application/json" },
            method = RequestMethod.POST)
    SearchModelResponse getSearchModelResponse(@ApiParam(value = "发票查询请求") @RequestBody AbandonInvoiceCheckRequest abandonInvoiceCheckRequest);

    @ApiOperation(value = "由查询条件获取searchModel", notes = "", response = SearchModelResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "Export", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = SearchModelResponse.class) })
    @RequestMapping(value = "/export/getPreInvoiceSearchModelResponse",
            produces = { "application/json" },
            method = RequestMethod.POST)
    SearchModelResponse getPreInvoiceSearchModelResponse(@ApiParam(value = "发票查询请求") @RequestBody PreInvoiceRequest preInvoiceRequest);

    @ApiOperation(value = "根据预制发票Id查询原单据号", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "Export", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = SearchModelResponse.class) })
    @RequestMapping(value = "/export/getSalesbillNoByPreInvoiceId",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response getSalesbillNoByPreInvoiceId(@ApiParam(value = "根据预制发票Id查询原单据号") @RequestBody PreInvoiceId PreInvoiceIdl);


    @ApiOperation(value = "组装文件导出发票的查询对象(带权限和默认条件设置) searchModel", notes = "", response = SearchModelResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "Export", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = SearchModelResponse.class) })
    @RequestMapping(value = "/export/querySearchModelResponse",
            produces = { "application/json" },
            method = RequestMethod.POST)
    SearchModelResponse querySearchModelResponse(@ApiParam(value = "发票的查询条件") @RequestBody ExportSellerInvoiceRequest exportSellerInvoiceRequest);

}
