package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 项目名称:
 * 模块名称:
 * 说明:
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2019/7/17 14:24
 */
public interface UITestApi {

    @ApiOperation(value = "发票 - 查看业务单号对应的发票", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "Test", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/test/query-invoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response queryInvoice(@ApiParam(value = "明细请求参数") @RequestBody List<String> salesBillNoList);


    @ApiOperation(value = "根据业务单id查询红冲或作废数量", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"Test",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/test/abandonOrHCCount",
            produces = {"application/json"},
            method = RequestMethod.GET)
    Response abandonOrHCCount(@RequestParam(value = "salesbillId", required = false) long salesbillId,@RequestParam(value = "hcOrAbandon", required = false)  int hcOrAbandon);


    @ApiOperation(value = "预制发票 - 查看拆票结果", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "Test", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/test/query-pre-invoice-by-sales-bill-id",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response queryPreInvoice(@ApiParam(value = "明细请求参数") @RequestBody List<Long> billIdList);
}
