package com.xforceplus.seller.invoice.client.api.report;

import com.xforceplus.seller.invoice.client.model.report.ImportReportDataRequest;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 项目名称: 票易通
 * 模块名称: 报表信息导入管理API
 * JDK 版本: JDK1.8
 * 说明: 报表信息从集成同步到平台相关的API
 * 作者(@author): wangjingshuang
 * 创建时间: 2020年4月23日20:56:22
 */
@Api(value = "MsImportReportDataApi", description = "the MsImportReportDataApi API")
public interface MsImportReportDataApi {

    @ApiOperation(value = "同步集成报表信息到平台", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags = {"MsImportReportDataApi",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/report/importReportData",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response importReportData(@ApiParam(value = "报表数据导入请求") @RequestBody ImportReportDataRequest importReportDataRequest);
}
