package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * AbandonInvoiceCheckResponse
 */

@JsonInclude(NON_NULL)
public class AbandonInvoiceCheckResponse {
  @JsonProperty("code")
  private Integer code = 1;

  @JsonProperty("message")
  private String message = "获取成功!";

/*  @JsonProperty("result")
  private AbandonInvoiceCheckResult result = null;*/

  @JsonProperty("result")
  private AbandonInvoiceConfigResult result = null;

  @JsonIgnore
  public AbandonInvoiceCheckResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * Get code
   * @return code
  **/
  @ApiModelProperty(value = "")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public AbandonInvoiceCheckResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * Get message
   * @return message
  **/
  @ApiModelProperty(value = "")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

/*  @JsonIgnore
  public AbandonInvoiceCheckResponse result(AbandonInvoiceCheckResult result) {
    this.result = result;
    return this;
  }

   *//**
   * 作废校验结果
   * @return result
  **//*
  @ApiModelProperty(value = "作废校验结果")
  public AbandonInvoiceCheckResult getResult() {
    return result;
  }

  public void setResult(AbandonInvoiceCheckResult result) {
    this.result = result;
  }*/

  @JsonIgnore
  public AbandonInvoiceCheckResponse result(AbandonInvoiceConfigResult result) {
    this.result = result;
    return this;
  }

  /**
   * 作废校验结果
   * @return result
   **/
  @ApiModelProperty(value = "作废校验结果")
  public AbandonInvoiceConfigResult getResult() {
    return result;
  }

  public void setResult(AbandonInvoiceConfigResult result) {
    this.result = result;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AbandonInvoiceCheckResponse abandonInvoiceCheckResponse = (AbandonInvoiceCheckResponse) o;
    return Objects.equals(this.code, abandonInvoiceCheckResponse.code) &&
        Objects.equals(this.message, abandonInvoiceCheckResponse.message) &&
        //Objects.equals(this.result, abandonInvoiceCheckResponse.result)&&
        Objects.equals(this.result, abandonInvoiceCheckResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, /*result,*/ result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AbandonInvoiceCheckResponse {\n");

    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    //sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("    abandonInvoiceConfigResult: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
