package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@JsonInclude(NON_NULL)
public class AbandonInvoiceConfigItem {

    @JsonProperty("text")
    private String text;

    @JsonProperty("value")
    private Integer value = null;

    @JsonIgnore
    public AbandonInvoiceConfigItem text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty("配置描述")
    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @JsonIgnore
    public AbandonInvoiceConfigItem value(Integer value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty("配置值")
    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if ((o == null) || (getClass() != o.getClass())) {
            return false;
        }
        AbandonInvoiceConfigItem billUploadMain = (AbandonInvoiceConfigItem) o;
        return (Objects.equals(text, text)) && (Objects.equals(text, text))
                && (Objects.equals(value, value)) && (Objects.equals(value, value));
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[] { text, value});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AbandonInvoiceConfigItem {\n");

        sb.append("    text: ").append(toIndentedString(text)).append("\n");
        sb.append("    value: ").append(toIndentedString(value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
