package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 项目名称:
 * 模块名称:
 * 说明:
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2019/8/8 18:38
 */
@JsonInclude(NON_NULL)
public class AutoInvoiceRequest {

    @ApiModelProperty(value = "预制发票id")
    @JsonProperty("preInvoiceIdList")
    private List<Long> preInvoiceIdList;

    @ApiModelProperty(value = "自动开具终端编码")
    @JsonProperty("terminalCode")
    private String terminalCode;
    @ApiModelProperty(value = "自动开具终端名称")
    @JsonProperty("terminalName")
    private String terminalName;

    @ApiModelProperty(value = "自动开具终端编码")
    @JsonProperty("taskId")
    private Long taskId;

    public String getTerminalCode() {
        return terminalCode;
    }

    public void setTerminalCode(String terminalCode) {
        this.terminalCode = terminalCode;
    }

    public Long getTaskId() {
        return taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public List<Long> getPreInvoiceIdList() {
        return preInvoiceIdList;
    }

    public void setPreInvoiceIdList(List<Long> preInvoiceIdList) {
        this.preInvoiceIdList = preInvoiceIdList;
    }

    public String getTerminalName() {
        return terminalName;
    }

    public void setTerminalName(String terminalName) {
        this.terminalName = terminalName;
    }

    @Override
    public String toString() {
        return "AutoInvoiceRequest{" +
                "preInvoiceIdList=" + preInvoiceIdList +
                ", terminalCode='" + terminalCode + '\'' +
                ", terminalName='" + terminalName + '\'' +
                ", taskId=" + taskId +
                '}';
    }
}
