package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 单据与发票的匹配关系信息
 */
@ApiModel(description = "单据与发票的匹配关系信息")

@JsonInclude(NON_NULL)
public class BillInvoiceMatchedRelationInfo {

  @JsonProperty("salesbillId")
  private Long salesbillId = null;

  @JsonProperty("invoiceId")
  private Long invoiceId = null;

  @JsonIgnore
  public BillInvoiceMatchedRelationInfo salesbillId(Long salesbillId) {
    this.salesbillId = salesbillId;
    return this;
  }

   /**
   * 单据Id
   * @return salesbillId
  **/
  @ApiModelProperty(value = "单据Id")
  public Long getSalesbillId() {
    return salesbillId;
  }

  public void setSalesbillId(Long salesbillId) {
    this.salesbillId = salesbillId;
  }

  @JsonIgnore
  public BillInvoiceMatchedRelationInfo invoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
    return this;
  }

   /**
   * 发票Id
   * @return invoiceId
  **/
  @ApiModelProperty(value = "发票Id")
  public Long getInvoiceId() {
    return invoiceId;
  }

  public void setInvoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BillInvoiceMatchedRelationInfo billInvoiceMatchedRelationInfo = (BillInvoiceMatchedRelationInfo) o;
    return Objects.equals(this.salesbillId, billInvoiceMatchedRelationInfo.salesbillId) &&
        Objects.equals(this.invoiceId, billInvoiceMatchedRelationInfo.invoiceId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(salesbillId, invoiceId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BillInvoiceMatchedRelationInfo {\n");
    sb.append("    salesbillId: ").append(toIndentedString(salesbillId)).append("\n");
    sb.append("    invoiceId: ").append(toIndentedString(invoiceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
