package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 发票操作日志信息
 */
@ApiModel(description = "发票操作日志信息")

@JsonInclude(NON_NULL)
public class InvoiceOperationLog {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("businessId")
  private Long businessId = null;

  @JsonProperty("operationType")
  private Integer operationType = null;

  @JsonProperty("operationDesc")
  private String operationDesc = null;

  @JsonProperty("operationContent")
  private String operationContent = null;

  @JsonProperty("operationRemark")
  private String operationRemark = null;

  @JsonProperty("operationTime")
  private Date operationTime = null;

  @JsonProperty("operationUserId")
  private Long operationUserId = null;

  @JsonProperty("operationUserName")
  private String operationUserName = null;

  @JsonProperty("createTime")
  private Date createTime = null;

  @JsonIgnore
  public InvoiceOperationLog id(Long id) {
    this.id = id;
    return this;
  }

  /**
   * 日志id
   * @return id
   **/
  @ApiModelProperty(value = "日志id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public InvoiceOperationLog businessId(Long businessId) {
    this.businessId = businessId;
    return this;
  }

  /**
   * 业务id
   * @return businessId
   **/
  @ApiModelProperty(value = "业务id")
  public Long getBusinessId() {
    return businessId;
  }

  public void setBusinessId(Long businessId) {
    this.businessId = businessId;
  }

  @JsonIgnore
  public InvoiceOperationLog operationType(Integer operationType) {
    this.operationType = operationType;
    return this;
  }

  /**
   * 发票操作类型：1-打印；2-打印销货清单；3-作废；4-红冲；5-开具对应红票；6-开具；7-开具并打印；8-抽取；9-申请退票；10-驳回退票申请；11-锁定；12-解锁；13-pdf发送；14-购方退回；15-付款状态同步；16-认证状态同步；17-申请红字信息表
   * @return operationType
   **/
  @ApiModelProperty(value = "发票操作类型：1-打印；2-打印销货清单；3-作废；4-红冲；5-开具对应红票；6-开具；7-开具并打印；8-抽取；9-申请退票；10-驳回退票申请；11-锁定；12-解锁；13-pdf发送；14-购方退回；15-付款状态同步；16-认证状态同步；17-申请红字信息表")
  public Integer getOperationType() {
    return operationType;
  }

  public void setOperationType(Integer operationType) {
    this.operationType = operationType;
  }

  @JsonIgnore
  public InvoiceOperationLog operationDesc(String operationDesc) {
    this.operationDesc = operationDesc;
    return this;
  }

  /**
   * 业务操作描述
   * @return operationDesc
   **/
  @ApiModelProperty(value = "业务操作描述")
  public String getOperationDesc() {
    return operationDesc;
  }

  public void setOperationDesc(String operationDesc) {
    this.operationDesc = operationDesc;
  }

  @JsonIgnore
  public InvoiceOperationLog operationContent(String operationContent) {
    this.operationContent = operationContent;
    return this;
  }

  /**
   * 业务操作内容
   * @return operationContent
   **/
  @ApiModelProperty(value = "业务操作内容")
  public String getOperationContent() {
    return operationContent;
  }

  public void setOperationContent(String operationContent) {
    this.operationContent = operationContent;
  }

  @JsonIgnore
  public InvoiceOperationLog operationRemark(String operationRemark) {
    this.operationRemark = operationRemark;
    return this;
  }

  /**
   * 业务操作原因备注
   * @return operationRemark
   **/
  @ApiModelProperty(value = "业务操作原因备注")
  public String getOperationRemark() {
    return operationRemark;
  }

  public void setOperationRemark(String operationRemark) {
    this.operationRemark = operationRemark;
  }
  @JsonIgnore
  public InvoiceOperationLog operationTime(Date operationTime) {
    this.operationTime = operationTime;
    return this;
  }

  /**
   * 操作时间
   * @return operationTime
   **/
  @ApiModelProperty(value = "操作时间")
  public Date getOperationTime() {
    return operationTime;
  }

  public void setOperationTime(Date operationTime) {
    this.operationTime = operationTime;
  }

  @JsonIgnore
  public InvoiceOperationLog operationUserId(Long operationUserId) {
    this.operationUserId = operationUserId;
    return this;
  }

  /**
   * 操作用户id
   * @return operationUserId
   **/
  @ApiModelProperty(value = "操作用户id")
  public Long getOperationUserId() {
    return operationUserId;
  }

  public void setOperationUserId(Long operationUserId) {
    this.operationUserId = operationUserId;
  }

  @JsonIgnore
  public InvoiceOperationLog operationUserName(String operationUserName) {
    this.operationUserName = operationUserName;
    return this;
  }

  /**
   * 操作用户名
   * @return operationUserName
   **/
  @ApiModelProperty(value = "操作用户名")
  public String getOperationUserName() {
    return operationUserName;
  }

  public void setOperationUserName(String operationUserName) {
    this.operationUserName = operationUserName;
  }

  @JsonIgnore
  public InvoiceOperationLog createTime(Date createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * 创建时间
   * @return createTime
   **/
  @ApiModelProperty(value = "创建时间")
  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceOperationLog invoiceOperationLog = (InvoiceOperationLog) o;
    return Objects.equals(this.id, invoiceOperationLog.id) &&
            Objects.equals(this.businessId, invoiceOperationLog.businessId) &&
            Objects.equals(this.operationType, invoiceOperationLog.operationType) &&
            Objects.equals(this.operationDesc, invoiceOperationLog.operationDesc) &&
            Objects.equals(this.operationContent, invoiceOperationLog.operationContent) &&
            Objects.equals(this.operationTime, invoiceOperationLog.operationTime) &&
            Objects.equals(this.operationUserId, invoiceOperationLog.operationUserId) &&
            Objects.equals(this.operationUserName, invoiceOperationLog.operationUserName) &&
            Objects.equals(this.createTime, invoiceOperationLog.createTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, businessId, operationType, operationDesc, operationContent, operationTime, operationUserId, operationUserName, createTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceOperationLog {\n");

    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    businessId: ").append(toIndentedString(businessId)).append("\n");
    sb.append("    operationType: ").append(toIndentedString(operationType)).append("\n");
    sb.append("    operationDesc: ").append(toIndentedString(operationDesc)).append("\n");
    sb.append("    operationContent: ").append(toIndentedString(operationContent)).append("\n");
    sb.append("    operationTime: ").append(toIndentedString(operationTime)).append("\n");
    sb.append("    operationUserId: ").append(toIndentedString(operationUserId)).append("\n");
    sb.append("    operationUserName: ").append(toIndentedString(operationUserName)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
