package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * LockInvoiceByIdsRequest
 */

@JsonInclude(NON_NULL)
public class LockInvoiceByIdsRequest {


  @JsonProperty("type")
  private Integer lockFlag = null;

  @ApiModelProperty("invoiceIds")
  private List<Long> invoiceIds = new ArrayList<Long>();


  @JsonIgnore
  public LockInvoiceByIdsRequest type(Integer lockFlag) {
    this.lockFlag = lockFlag;
    return this;
  }

   /**
   * 锁类型：0-解锁 1-锁定
   * @return type
  **/
  @ApiModelProperty(value = "锁类型：0-解锁 1-锁定")
  public Integer getLockFlag() {
    return lockFlag;
  }

  public void setLockFlag(Integer lockFlag) {
    this.lockFlag = lockFlag;
  }

   /**
   * 发票序列号主键列表
   * @return invoiceIds
  **/
  @ApiModelProperty(value = "发票序列号主键列表")

  public List<Long> getInvoiceIds() {
    return invoiceIds;
  }

  public void setInvoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LockInvoiceByIdsRequest lockInvoiceRequest = (LockInvoiceByIdsRequest) o;
    return  Objects.equals(this.lockFlag, lockInvoiceRequest.lockFlag) &&
        Objects.equals(this.invoiceIds, lockInvoiceRequest.invoiceIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash( lockFlag, invoiceIds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LockInvoiceByIdsRequest {\n");

    sb.append("    lockFlag: ").append(toIndentedString(lockFlag)).append("\n");
    sb.append("    invoiceIds: ").append(toIndentedString(invoiceIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
