package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 作废发票校验信息
 */
@ApiModel(description = "作废校验接口结果")

@JsonInclude(NON_NULL)
public class LockInvoiceCheckInfo {


    @ApiModelProperty(value = "发票代码")
    private String invoiceCode ;

    @ApiModelProperty(value = "发票号码")
    private String invoiceNo ;


    public LockInvoiceCheckInfo(){

    }
    public LockInvoiceCheckInfo( String invoiceCode, String invoiceNo) {
        this.invoiceCode = invoiceCode;
        this.invoiceNo = invoiceNo;
    }


    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

}
