package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.xforceplus.xplatframework.apimodel.PollingModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 数据
 */
@ApiModel(description = "数据")

@JsonInclude(NON_NULL)
public class MakeOutStatusData extends PollingModel {

    public static final int NOT_DONE = 0;

    public static final int DONE = 1;

    //5 Ukey
    private Integer terminalType ;
    //0 开具 1开具打印
    private Integer operationType ;

    public Integer getTerminalType() {
        return terminalType;
    }

    public void setTerminalType(Integer terminalType) {
        this.terminalType = terminalType;
    }

    public Integer getOperationType() {
        return operationType;
    }

    public void setOperationType(Integer operationType) {
        this.operationType = operationType;
    }

    @ApiModelProperty(value = "开具信息")
    private MakeOutStatusInfo makeOutStatusInfo = null;


    public MakeOutStatusInfo getMakeOutStatusInfo() {
        return makeOutStatusInfo;
    }

    public void setMakeOutStatusInfo(MakeOutStatusInfo makeOutStatusInfo) {
        this.makeOutStatusInfo = makeOutStatusInfo;
    }

    @Override
    public String toString() {
        return "MakeOutStatusData{" +
                "makeOutStatusInfo=" + makeOutStatusInfo +
                "} " + super.toString();
    }
}
