package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsEditRedNoDetailRequest {
  @JsonProperty("businessBillType")
  private String businessBillType = null;

  @JsonProperty("userRole")
  private String userRole = null;

  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("paperDrawDate")
  private String paperDrawDate = null;

  public String getPaperDrawDate() {
    return paperDrawDate;
  }

  public void setPaperDrawDate(String paperDrawDate) {
    this.paperDrawDate = paperDrawDate;
  }



  @JsonIgnore
  public MsEditRedNoDetailRequest businessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
    return this;
  }

   /**
   * AP：购方 AR-销方
   * @return businessBillType
  **/
  @ApiModelProperty(value = "AP：购方 AR-销方")
  public String getBusinessBillType() {
    return businessBillType;
  }

  public void setBusinessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
  }

  @JsonIgnore
  public MsEditRedNoDetailRequest userRole(String userRole) {
    this.userRole = userRole;
    return this;
  }

   /**
   * 1 销方 2购方
   * @return userRole
  **/
  @ApiModelProperty(value = "1 销方 2购方")
  public String getUserRole() {
    return userRole;
  }

  public void setUserRole(String userRole) {
    this.userRole = userRole;
  }

  @JsonIgnore
  public MsEditRedNoDetailRequest id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键ID
   * @return id
  **/
  @ApiModelProperty(value = "主键ID")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsEditRedNoDetailRequest invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public MsEditRedNoDetailRequest invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsEditRedNoDetailRequest editRedNoDetailRequest = (MsEditRedNoDetailRequest) o;
    return Objects.equals(this.businessBillType, editRedNoDetailRequest.businessBillType) &&
        Objects.equals(this.userRole, editRedNoDetailRequest.userRole) &&
        Objects.equals(this.id, editRedNoDetailRequest.id) &&
        Objects.equals(this.invoiceCode, editRedNoDetailRequest.invoiceCode) &&
        Objects.equals(this.invoiceNo, editRedNoDetailRequest.invoiceNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessBillType, userRole, id, invoiceCode, invoiceNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsEditRedNoDetailRequest {\n");

    sb.append("    businessBillType: ").append(toIndentedString(businessBillType)).append("\n");
    sb.append("    userRole: ").append(toIndentedString(userRole)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
