package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSubmitRedNoAllRequest {
  @JsonProperty("applyType")
  private Integer applyType = null;

  @JsonProperty("preInvoiceIds")
  private List<Long> preInvoiceIds = new ArrayList<Long>();

  @JsonProperty("deviceUn")
  private String deviceUn = null;

  @JsonProperty("directOnlineFlag")
  private Integer directOnlineFlag = null;

  @JsonProperty("printerOnlineFlag")
  private Integer printerOnlineFlag = null;

  @JsonProperty("terminalUn")
  private String terminalUn = null;

  @JsonProperty("terminalName")
  private String terminalName = null;

  @JsonProperty("terminalType")
  private String terminalType = null;

  @JsonIgnore
  public MsSubmitRedNoAllRequest applyType(Integer applyType) {
    this.applyType = applyType;
    return this;
  }

   /**
   * 申请类型 1-销方申请,2-购方申请——未抵扣,3-购方申请——已抵扣
   * @return applyType
  **/
  @ApiModelProperty(value = "申请类型 1-销方申请,2-购方申请——未抵扣,3-购方申请——已抵扣")
  public Integer getApplyType() {
    return applyType;
  }

  public void setApplyType(Integer applyType) {
    this.applyType = applyType;
  }

  @JsonIgnore
  public MsSubmitRedNoAllRequest preInvoiceIds(List<Long> preInvoiceIds) {
    this.preInvoiceIds = preInvoiceIds;
    return this;
  }

  public MsSubmitRedNoAllRequest addPreInvoiceIdsItem(Long preInvoiceIdsItem) {
    this.preInvoiceIds.add(preInvoiceIdsItem);
    return this;
  }

   /**
   * 发票对象
   * @return preInvoiceIds
  **/
  @ApiModelProperty(value = "发票对象")
  public List<Long> getPreInvoiceIds() {
    return preInvoiceIds;
  }

  public void setPreInvoiceIds(List<Long> preInvoiceIds) {
    this.preInvoiceIds = preInvoiceIds;
  }

  @JsonIgnore
  public MsSubmitRedNoAllRequest deviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
    return this;
  }

   /**
   * 开票设备ID
   * @return deviceUn
  **/
  @ApiModelProperty(value = "开票设备ID")
  public String getDeviceUn() {
    return deviceUn;
  }

  public void setDeviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
  }

  @JsonIgnore
  public MsSubmitRedNoAllRequest directOnlineFlag(Integer directOnlineFlag) {
    this.directOnlineFlag = directOnlineFlag;
    return this;
  }

   /**
   * directOnlineFlag
   * @return directOnlineFlag
  **/
  @ApiModelProperty(value = "directOnlineFlag")
  public Integer getDirectOnlineFlag() {
    return directOnlineFlag;
  }

  public void setDirectOnlineFlag(Integer directOnlineFlag) {
    this.directOnlineFlag = directOnlineFlag;
  }

  @JsonIgnore
  public MsSubmitRedNoAllRequest printerOnlineFlag(Integer printerOnlineFlag) {
    this.printerOnlineFlag = printerOnlineFlag;
    return this;
  }

   /**
   * printerOnlineFlag
   * @return printerOnlineFlag
  **/
  @ApiModelProperty(value = "printerOnlineFlag")
  public Integer getPrinterOnlineFlag() {
    return printerOnlineFlag;
  }

  public void setPrinterOnlineFlag(Integer printerOnlineFlag) {
    this.printerOnlineFlag = printerOnlineFlag;
  }

  @JsonIgnore
  public MsSubmitRedNoAllRequest terminalUn(String terminalUn) {
    this.terminalUn = terminalUn;
    return this;
  }

   /**
   * terminalId
   * @return terminalUn
  **/
  @ApiModelProperty(value = "terminalId")
  public String getTerminalUn() {
    return terminalUn;
  }

  public void setTerminalUn(String terminalUn) {
    this.terminalUn = terminalUn;
  }

  @JsonIgnore
  public MsSubmitRedNoAllRequest terminalName(String terminalName) {
    this.terminalName = terminalName;
    return this;
  }

   /**
   * terminalName
   * @return terminalName
  **/
  @ApiModelProperty(value = "terminalName")
  public String getTerminalName() {
    return terminalName;
  }

  public void setTerminalName(String terminalName) {
    this.terminalName = terminalName;
  }

  @JsonIgnore
  public MsSubmitRedNoAllRequest terminalType(String terminalType) {
    this.terminalType = terminalType;
    return this;
  }

   /**
   * terminalType
   * @return terminalType
  **/
  @ApiModelProperty(value = "terminalType")
  public String getTerminalType() {
    return terminalType;
  }

  public void setTerminalType(String terminalType) {
    this.terminalType = terminalType;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSubmitRedNoAllRequest submitRedNoAllRequest = (MsSubmitRedNoAllRequest) o;
    return Objects.equals(this.applyType, submitRedNoAllRequest.applyType) &&
        Objects.equals(this.preInvoiceIds, submitRedNoAllRequest.preInvoiceIds) &&
        Objects.equals(this.deviceUn, submitRedNoAllRequest.deviceUn) &&
        Objects.equals(this.directOnlineFlag, submitRedNoAllRequest.directOnlineFlag) &&
        Objects.equals(this.printerOnlineFlag, submitRedNoAllRequest.printerOnlineFlag) &&
        Objects.equals(this.terminalUn, submitRedNoAllRequest.terminalUn) &&
        Objects.equals(this.terminalName, submitRedNoAllRequest.terminalName) &&
        Objects.equals(this.terminalType, submitRedNoAllRequest.terminalType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(applyType, preInvoiceIds, deviceUn, directOnlineFlag, printerOnlineFlag, terminalUn, terminalName, terminalType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSubmitRedNoAllRequest {\n");

    sb.append("    applyType: ").append(toIndentedString(applyType)).append("\n");
    sb.append("    preInvoiceIds: ").append(toIndentedString(preInvoiceIds)).append("\n");
    sb.append("    deviceUn: ").append(toIndentedString(deviceUn)).append("\n");
    sb.append("    directOnlineFlag: ").append(toIndentedString(directOnlineFlag)).append("\n");
    sb.append("    printerOnlineFlag: ").append(toIndentedString(printerOnlineFlag)).append("\n");
    sb.append("    terminalUn: ").append(toIndentedString(terminalUn)).append("\n");
    sb.append("    terminalName: ").append(toIndentedString(terminalName)).append("\n");
    sb.append("    terminalType: ").append(toIndentedString(terminalType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
