package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 预制发票明细信息
 */
@ApiModel(description = "预制发票明细信息")

@JsonInclude(NON_NULL)
public class PreInvoiceDetail {

    @ApiModelProperty("单据id")
    private Long billId;

    @ApiModelProperty("单据明细id")
    private Long billItemId;


    @JsonProperty("id")
    private Long id = null;

    @JsonProperty("preInvoiceId")
    private Long preInvoiceId = null;

    @JsonProperty("goodsTaxNo")
    private String goodsTaxNo = null;

    @JsonProperty("cargoName")
    private String cargoName = null;

    @JsonProperty("cargoCode")
    private String cargoCode = null;

    @JsonProperty("itemSpec")
    private String itemSpec = null;

    @JsonProperty("unitPrice")
    private BigDecimal unitPrice = null;

    @JsonProperty("quantity")
    private BigDecimal quantity = null;

    @JsonProperty("quantityUnit")
    private String quantityUnit = null;

    @JsonProperty("taxRate")
    private BigDecimal taxRate = null;

    @JsonProperty("amountWithoutTax")
    private BigDecimal amountWithoutTax = null;

    @JsonProperty("taxAmount")
    private BigDecimal taxAmount = null;

    @JsonProperty("amountWithTax")
    private BigDecimal amountWithTax = null;

    @JsonProperty("discountWithoutTax")
    private BigDecimal discountWithoutTax = null;

    @JsonProperty("discountTax")
    private BigDecimal discountTax = null;

    @JsonProperty("discountWithTax")
    private BigDecimal discountWithTax = null;

    @JsonProperty("discountRate")
    private BigDecimal discountRate = null;

    @JsonProperty("floatingAmount")
    private BigDecimal floatingAmount = null;

    @JsonProperty("taxItem")
    private String taxItem = null;

    @JsonProperty("goodsNoVer")
    private String goodsNoVer = null;

    @JsonProperty("taxPre")
    private String taxPre = null;

    @JsonProperty("taxPreCon")
    private String taxPreCon = null;

    @JsonProperty("zeroTax")
    private String zeroTax = null;

    @JsonProperty("deduction")
    private BigDecimal deduction = null;

    @JsonProperty("discountFlag")
    private String discountFlag = null;

    @JsonProperty("priceMethod")
    private String priceMethod = null;

    @JsonProperty("printContentFlag")
    private String printContentFlag = null;

    @ApiModelProperty(value = "显示税率")
    private String taxRateStr;

    @ApiModelProperty("显示税额")
    private String taxAmountStr;

    public String getTaxAmountStr() {
        return taxAmountStr;
    }

    public void setTaxAmountStr(String taxAmountStr) {
        this.taxAmountStr = taxAmountStr;
    }

    public String getTaxRateStr() {
        return taxRateStr;
    }

    public void setTaxRateStr(String taxRateStr) {
        this.taxRateStr = taxRateStr;
    }

    @JsonIgnore
    public PreInvoiceDetail id(Long id) {
        this.id = id;
        return this;
    }

    /**
     * 预制发票明细id
     *
     * @return id
     **/
    @ApiModelProperty(value = "预制发票明细id")
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public PreInvoiceDetail preInvoiceId(Long preInvoiceId) {
        this.preInvoiceId = preInvoiceId;
        return this;
    }

    /**
     * 预制发票id
     *
     * @return preInvoiceId
     **/
    @ApiModelProperty(value = "预制发票id")
    public Long getPreInvoiceId() {
        return preInvoiceId;
    }

    public void setPreInvoiceId(Long preInvoiceId) {
        this.preInvoiceId = preInvoiceId;
    }

    @JsonIgnore
    public PreInvoiceDetail goodsTaxNo(String goodsTaxNo) {
        this.goodsTaxNo = goodsTaxNo;
        return this;
    }

    /**
     * 税收分类编码
     *
     * @return goodsTaxNo
     **/
    @ApiModelProperty(value = "税收分类编码")
    public String getGoodsTaxNo() {
        return goodsTaxNo;
    }

    public void setGoodsTaxNo(String goodsTaxNo) {
        this.goodsTaxNo = goodsTaxNo;
    }

    @JsonIgnore
    public PreInvoiceDetail cargoName(String cargoName) {
        this.cargoName = cargoName;
        return this;
    }

    /**
     * 货物或应税劳务名称
     *
     * @return cargoName
     **/
    @ApiModelProperty(value = "货物或应税劳务名称")
    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    @JsonIgnore
    public PreInvoiceDetail cargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
        return this;
    }

    /**
     * 货物或应税劳务代码
     *
     * @return cargoCode
     **/
    @ApiModelProperty(value = "货物或应税劳务代码")
    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    @JsonIgnore
    public PreInvoiceDetail itemSpec(String itemSpec) {
        this.itemSpec = itemSpec;
        return this;
    }

    /**
     * 规格型号
     *
     * @return itemSpec
     **/
    @ApiModelProperty(value = "规格型号")
    public String getItemSpec() {
        return itemSpec;
    }

    public void setItemSpec(String itemSpec) {
        this.itemSpec = itemSpec;
    }

    @JsonIgnore
    public PreInvoiceDetail unitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
        return this;
    }

    /**
     * 单价不含税
     *
     * @return unitPrice
     **/
    @ApiModelProperty(value = "单价不含税")
    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    @JsonIgnore
    public PreInvoiceDetail quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    /**
     * 数量
     *
     * @return quantity
     **/
    @ApiModelProperty(value = "数量")
    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    @JsonIgnore
    public PreInvoiceDetail quantityUnit(String quantityUnit) {
        this.quantityUnit = quantityUnit;
        return this;
    }

    /**
     * 单位
     *
     * @return quantityUnit
     **/
    @ApiModelProperty(value = "单位")
    public String getQuantityUnit() {
        return quantityUnit;
    }

    public void setQuantityUnit(String quantityUnit) {
        this.quantityUnit = quantityUnit;
    }

    @JsonIgnore
    public PreInvoiceDetail taxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    /**
     * 税率
     *
     * @return taxRate
     **/
    @ApiModelProperty(value = "税率")
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    @JsonIgnore
    public PreInvoiceDetail amountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
        return this;
    }

    /**
     * 不含税金额
     *
     * @return amountWithoutTax
     **/
    @ApiModelProperty(value = "不含税金额")
    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    @JsonIgnore
    public PreInvoiceDetail taxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    /**
     * 税额
     *
     * @return taxAmount
     **/
    @ApiModelProperty(value = "税额")
    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    @JsonIgnore
    public PreInvoiceDetail amountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
        return this;
    }

    /**
     * 含税金额
     *
     * @return amountWithTax
     **/
    @ApiModelProperty(value = "含税金额")
    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    @JsonIgnore
    public PreInvoiceDetail discountWithoutTax(BigDecimal discountWithoutTax) {
        this.discountWithoutTax = discountWithoutTax;
        return this;
    }

    /**
     * 不含税折扣金额
     *
     * @return discountWithoutTax
     **/
    @ApiModelProperty(value = "不含税折扣金额")
    public BigDecimal getDiscountWithoutTax() {
        return discountWithoutTax;
    }

    public void setDiscountWithoutTax(BigDecimal discountWithoutTax) {
        this.discountWithoutTax = discountWithoutTax;
    }

    @JsonIgnore
    public PreInvoiceDetail discountTax(BigDecimal discountTax) {
        this.discountTax = discountTax;
        return this;
    }

    /**
     * 折扣税额
     *
     * @return discountTax
     **/
    @ApiModelProperty(value = "折扣税额")
    public BigDecimal getDiscountTax() {
        return discountTax;
    }

    public void setDiscountTax(BigDecimal discountTax) {
        this.discountTax = discountTax;
    }

    @JsonIgnore
    public PreInvoiceDetail discountWithTax(BigDecimal discountWithTax) {
        this.discountWithTax = discountWithTax;
        return this;
    }

    /**
     * 含税折扣金额
     *
     * @return discountWithTax
     **/
    @ApiModelProperty(value = "含税折扣金额")
    public BigDecimal getDiscountWithTax() {
        return discountWithTax;
    }

    public void setDiscountWithTax(BigDecimal discountWithTax) {
        this.discountWithTax = discountWithTax;
    }

    @JsonIgnore
    public PreInvoiceDetail discountRate(BigDecimal discountRate) {
        this.discountRate = discountRate;
        return this;
    }

    /**
     * 折扣率
     *
     * @return discountRate
     **/
    @ApiModelProperty(value = "折扣率")
    public BigDecimal getDiscountRate() {
        return discountRate;
    }

    public void setDiscountRate(BigDecimal discountRate) {
        this.discountRate = discountRate;
    }

    @JsonIgnore
    public PreInvoiceDetail floatingAmount(BigDecimal floatingAmount) {
        this.floatingAmount = floatingAmount;
        return this;
    }

    /**
     * 浮动金额(调整的容差金额)
     *
     * @return floatingAmount
     **/
    @ApiModelProperty(value = "浮动金额(调整的容差金额)")
    public BigDecimal getFloatingAmount() {
        return floatingAmount;
    }

    public void setFloatingAmount(BigDecimal floatingAmount) {
        this.floatingAmount = floatingAmount;
    }

    @JsonIgnore
    public PreInvoiceDetail taxItem(String taxItem) {
        this.taxItem = taxItem;
        return this;
    }

    /**
     * 商品税目
     *
     * @return taxItem
     **/
    @ApiModelProperty(value = "商品税目")
    public String getTaxItem() {
        return taxItem;
    }

    public void setTaxItem(String taxItem) {
        this.taxItem = taxItem;
    }

    @JsonIgnore
    public PreInvoiceDetail goodsNoVer(String goodsNoVer) {
        this.goodsNoVer = goodsNoVer;
        return this;
    }

    /**
     * 编码版本号
     *
     * @return goodsNoVer
     **/
    @ApiModelProperty(value = "编码版本号")
    public String getGoodsNoVer() {
        return goodsNoVer;
    }

    public void setGoodsNoVer(String goodsNoVer) {
        this.goodsNoVer = goodsNoVer;
    }

    @JsonIgnore
    public PreInvoiceDetail taxPre(String taxPre) {
        this.taxPre = taxPre;
        return this;
    }

    /**
     * 是否享受税收优惠政策
     *
     * @return taxPre
     **/
    @ApiModelProperty(value = "是否享受税收优惠政策")
    public String getTaxPre() {
        return taxPre;
    }

    public void setTaxPre(String taxPre) {
        this.taxPre = taxPre;
    }

    @JsonIgnore
    public PreInvoiceDetail taxPreCon(String taxPreCon) {
        this.taxPreCon = taxPreCon;
        return this;
    }

    /**
     * 是否享受税收优惠政策
     *
     * @return taxPreCon
     **/
    @ApiModelProperty(value = "是否享受税收优惠政策")
    public String getTaxPreCon() {
        return taxPreCon;
    }

    public void setTaxPreCon(String taxPreCon) {
        this.taxPreCon = taxPreCon;
    }

    @JsonIgnore
    public PreInvoiceDetail zeroTax(String zeroTax) {
        this.zeroTax = zeroTax;
        return this;
    }

    /**
     * 零税率标识
     *
     * @return zeroTax
     **/
    @ApiModelProperty(value = "零税率标识")
    public String getZeroTax() {
        return zeroTax;
    }

    public void setZeroTax(String zeroTax) {
        this.zeroTax = zeroTax;
    }

    @JsonIgnore
    public PreInvoiceDetail deduction(BigDecimal deduction) {
        this.deduction = deduction;
        return this;
    }

    /**
     * 扣除额
     *
     * @return deduction
     **/
    @ApiModelProperty(value = "扣除额")
    public BigDecimal getDeduction() {
        return deduction;
    }

    public void setDeduction(BigDecimal deduction) {
        this.deduction = deduction;
    }

    @JsonIgnore
    public PreInvoiceDetail discountFlag(String discountFlag) {
        this.discountFlag = discountFlag;
        return this;
    }

    /**
     * 扣除行标记
     *
     * @return discountFlag
     **/
    @ApiModelProperty(value = "扣除行标记")
    public String getDiscountFlag() {
        return discountFlag;
    }

    public void setDiscountFlag(String discountFlag) {
        this.discountFlag = discountFlag;
    }

    @JsonIgnore
    public PreInvoiceDetail priceMethod(String priceMethod) {
        this.priceMethod = priceMethod;
        return this;
    }

    /**
     * 价格方式
     *
     * @return priceMethod
     **/
    @ApiModelProperty(value = "价格方式")
    public String getPriceMethod() {
        return priceMethod;
    }

    public void setPriceMethod(String priceMethod) {
        this.priceMethod = priceMethod;
    }

    @JsonIgnore
    public PreInvoiceDetail printContentFlag(String printContentFlag) {
        this.printContentFlag = printContentFlag;
        return this;
    }

    /**
     * 是否打印单价数量
     *
     * @return printContentFlag
     **/
    @ApiModelProperty(value = "是否打印单价数量")
    public String getPrintContentFlag() {
        return printContentFlag;
    }

    public void setPrintContentFlag(String printContentFlag) {
        this.printContentFlag = printContentFlag;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PreInvoiceDetail preInvoiceDetail = (PreInvoiceDetail) o;
        return Objects.equals(this.id, preInvoiceDetail.id)
                && Objects.equals(this.preInvoiceId, preInvoiceDetail.preInvoiceId)
                && Objects.equals(this.goodsTaxNo, preInvoiceDetail.goodsTaxNo)
                && Objects.equals(this.cargoName, preInvoiceDetail.cargoName)
                && Objects.equals(this.cargoCode, preInvoiceDetail.cargoCode)
                && Objects.equals(this.itemSpec, preInvoiceDetail.itemSpec)
                && Objects.equals(this.unitPrice, preInvoiceDetail.unitPrice)
                && Objects.equals(this.quantity, preInvoiceDetail.quantity)
                && Objects.equals(this.quantityUnit, preInvoiceDetail.quantityUnit)
                && Objects.equals(this.taxRate, preInvoiceDetail.taxRate)
                && Objects.equals(this.amountWithoutTax, preInvoiceDetail.amountWithoutTax)
                && Objects.equals(this.taxAmount, preInvoiceDetail.taxAmount)
                && Objects.equals(this.amountWithTax, preInvoiceDetail.amountWithTax)
                && Objects.equals(this.discountWithoutTax, preInvoiceDetail.discountWithoutTax)
                && Objects.equals(this.discountTax, preInvoiceDetail.discountTax)
                && Objects.equals(this.discountWithTax, preInvoiceDetail.discountWithTax)
                && Objects.equals(this.discountRate, preInvoiceDetail.discountRate)
                && Objects.equals(this.floatingAmount, preInvoiceDetail.floatingAmount)
                && Objects.equals(this.taxItem, preInvoiceDetail.taxItem)
                && Objects.equals(this.goodsNoVer, preInvoiceDetail.goodsNoVer)
                && Objects.equals(this.taxPre, preInvoiceDetail.taxPre)
                && Objects.equals(this.taxPreCon, preInvoiceDetail.taxPreCon)
                && Objects.equals(this.zeroTax, preInvoiceDetail.zeroTax)
                && Objects.equals(this.deduction, preInvoiceDetail.deduction)
                && Objects.equals(this.discountFlag, preInvoiceDetail.discountFlag)
                && Objects.equals(this.priceMethod, preInvoiceDetail.priceMethod)
                && Objects.equals(this.printContentFlag, preInvoiceDetail.printContentFlag);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, preInvoiceId, goodsTaxNo, cargoName, cargoCode, itemSpec, unitPrice, quantity,
                quantityUnit, taxRate, amountWithoutTax, taxAmount, amountWithTax, discountWithoutTax, discountTax,
                discountWithTax, discountRate, floatingAmount, taxItem, goodsNoVer, taxPre, taxPreCon, zeroTax,
                deduction, discountFlag, priceMethod, printContentFlag);
    }

    @Override
    public String toString() {
        return "PreInvoiceDetail{" +
                "id=" + id +
                ", preInvoiceId=" + preInvoiceId +
                ", goodsTaxNo='" + goodsTaxNo + '\'' +
                ", cargoName='" + cargoName + '\'' +
                ", cargoCode='" + cargoCode + '\'' +
                ", itemSpec='" + itemSpec + '\'' +
                ", unitPrice=" + unitPrice +
                ", quantity=" + quantity +
                ", quantityUnit='" + quantityUnit + '\'' +
                ", taxRate=" + taxRate +
                ", amountWithoutTax=" + amountWithoutTax +
                ", taxAmount=" + taxAmount +
                ", amountWithTax=" + amountWithTax +
                ", discountWithoutTax=" + discountWithoutTax +
                ", discountTax=" + discountTax +
                ", discountWithTax=" + discountWithTax +
                ", discountRate=" + discountRate +
                ", floatingAmount=" + floatingAmount +
                ", taxItem='" + taxItem + '\'' +
                ", goodsNoVer='" + goodsNoVer + '\'' +
                ", taxPre='" + taxPre + '\'' +
                ", taxPreCon='" + taxPreCon + '\'' +
                ", zeroTax='" + zeroTax + '\'' +
                ", deduction=" + deduction +
                ", discountFlag='" + discountFlag + '\'' +
                ", priceMethod='" + priceMethod + '\'' +
                ", printContentFlag='" + printContentFlag + '\'' +
                ", taxRateStr='" + taxRateStr + '\'' +
                ", taxAmountStr='" + taxAmountStr + '\'' +
                '}';
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public Long getBillId() {
        return billId;
    }

    public void setBillId(Long billId) {
        this.billId = billId;
    }

    public Long getBillItemId() {
        return billItemId;
    }

    public void setBillItemId(Long billItemId) {
        this.billItemId = billItemId;
    }
}
