package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 预制发票信息
 */
@ApiModel(description = "预制发票信息")

@JsonInclude(NON_NULL)
public class PreInvoiceMainInfo {
  @JsonProperty("preInvoiceDetailCount")
  private Integer preInvoiceDetailCount = null;

  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("batchNo")
  private Long batchNo = null;

  @ApiModelProperty("外部批次号")
  private Long outBatchNo;

  @JsonProperty("sellerTenantId")
  private String sellerTenantId = null;

  @JsonProperty("sellerNo")
  private String sellerNo = null;

  @JsonProperty("sellerCode")
  private String sellerCode = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("sellerTel")
  private String sellerTel = null;

  @JsonProperty("sellerAddress")
  private String sellerAddress = null;

  @JsonProperty("sellerBankName")
  private String sellerBankName = null;

  @JsonProperty("sellerBankAccount")
  private String sellerBankAccount = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("purchaserTenantId")
  private String purchaserTenantId = null;

    @JsonProperty("purchaserId")
    private String purchaserId = null;

  @JsonProperty("purchaserNo")
  private String purchaserNo = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("purchaserTel")
  private String purchaserTel = null;

  @JsonProperty("purchaserAddress")
  private String purchaserAddress = null;

  @JsonProperty("purchaserBankName")
  private String purchaserBankName = null;

  @JsonProperty("purchaserBankAccount")
  private String purchaserBankAccount = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("businessBillType")
  private String businessBillType = null;

  @JsonProperty("salesbillType")
  private String salesbillType = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("machineCode")
  private String machineCode = null;

  @JsonProperty("paperDrawDate")
  private String paperDrawDate = null;

  @JsonProperty("checkCode")
  private String checkCode = null;

  @JsonProperty("cashierName")
  private String cashierName = null;

  @JsonProperty("checkerName")
  private String checkerName = null;

  @JsonProperty("invoicerName")
  private String invoicerName = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("electronicSignature")
  private String electronicSignature = null;

  @JsonProperty("amountWithTax")
  private BigDecimal amountWithTax = null;

  @JsonProperty("amountWithoutTax")
  private BigDecimal amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("cipherText")
  private String cipherText = null;

    @ApiModelProperty("显示税率")
    private String taxRateStr;

    @ApiModelProperty("显示税额")
    private String taxAmountStr;

  @JsonProperty("cipherTextTwoCode")
  private String cipherTextTwoCode = null;

  @JsonProperty("preInvoiceDetails")
  private List<PreInvoiceDetail> preInvoiceDetails = new ArrayList<PreInvoiceDetail>();

  @ApiModelProperty("销货清单文件打印标志 (0-否, 1-是)")
  private int saleListFileFlag;

  @ApiModelProperty("打印内容标志 (0-打印单价和数量, 1-不打印单价和数量)")
  private int displayPriceQuality;

  @ApiModelProperty("业务单号")
  private String salesbillNo;

  @JsonIgnore
  public PreInvoiceMainInfo preInvoiceDetailCount(Integer preInvoiceDetailCount) {
    this.preInvoiceDetailCount = preInvoiceDetailCount;
    return this;
  }

   /**
   * 明细总数
     *
   * @return preInvoiceDetailCount
  **/
  @ApiModelProperty(value = "明细总数")
  public Integer getPreInvoiceDetailCount() {
    return preInvoiceDetailCount;
  }

  public void setPreInvoiceDetailCount(Integer preInvoiceDetailCount) {
    this.preInvoiceDetailCount = preInvoiceDetailCount;
  }

  @JsonIgnore
  public PreInvoiceMainInfo id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 预制发票id
     *
   * @return id
  **/
  @ApiModelProperty(value = "预制发票id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public PreInvoiceMainInfo batchNo(Long batchNo) {
    this.batchNo = batchNo;
    return this;
  }

   /**
   * 批次号
     *
   * @return batchNo
  **/
  @ApiModelProperty(value = "批次号")
  public Long getBatchNo() {
    return batchNo;
  }

  public void setBatchNo(Long batchNo) {
    this.batchNo = batchNo;
  }

  @JsonIgnore
  public PreInvoiceMainInfo sellerTenantId(String sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
    return this;
  }

   /**
   * 销方租户id
     *
   * @return sellerTenantId
  **/
  @ApiModelProperty(value = "销方租户id")
  public String getSellerTenantId() {
    return sellerTenantId;
  }

  public void setSellerTenantId(String sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
  }

  @JsonIgnore
  public PreInvoiceMainInfo sellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
    return this;
  }

   /**
   * 销方租户公司编号
     *
   * @return sellerNo
  **/
  @ApiModelProperty(value = "销方租户公司编号")
  public String getSellerNo() {
    return sellerNo;
  }

  public void setSellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
  }

  @JsonIgnore
  public PreInvoiceMainInfo sellerCode(String sellerCode) {
    this.sellerCode = sellerCode;
    return this;
  }

   /**
   * 销方公司代码
     *
   * @return sellerCode
  **/
  @ApiModelProperty(value = "销方公司代码")
  public String getSellerCode() {
    return sellerCode;
  }

  public void setSellerCode(String sellerCode) {
    this.sellerCode = sellerCode;
  }

  @JsonIgnore
  public PreInvoiceMainInfo sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
     *
   * @return sellerName
  **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public PreInvoiceMainInfo sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方纳税人识别号
     *
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "销方纳税人识别号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public PreInvoiceMainInfo sellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
    return this;
  }

   /**
   * 销方电话
     *
   * @return sellerTel
  **/
  @ApiModelProperty(value = "销方电话")
  public String getSellerTel() {
    return sellerTel;
  }

  public void setSellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
  }

  @JsonIgnore
  public PreInvoiceMainInfo sellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
    return this;
  }

   /**
   * 销方地址
     *
   * @return sellerAddress
  **/
  @ApiModelProperty(value = "销方地址")
  public String getSellerAddress() {
    return sellerAddress;
  }

  public void setSellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
  }

  @JsonIgnore
  public PreInvoiceMainInfo sellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
    return this;
  }

   /**
   * 销方银行名称
     *
   * @return sellerBankName
  **/
  @ApiModelProperty(value = "销方银行名称")
  public String getSellerBankName() {
    return sellerBankName;
  }

  public void setSellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
  }

  @JsonIgnore
  public PreInvoiceMainInfo sellerBankAccount(String sellerBankAccount) {
    this.sellerBankAccount = sellerBankAccount;
    return this;
  }

   /**
   * 销方银行账号
     *
   * @return sellerBankAccount
  **/
  @ApiModelProperty(value = "销方银行账号")
  public String getSellerBankAccount() {
    return sellerBankAccount;
  }

  public void setSellerBankAccount(String sellerBankAccount) {
    this.sellerBankAccount = sellerBankAccount;
  }

  @JsonIgnore
  public PreInvoiceMainInfo purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
     *
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public PreInvoiceMainInfo purchaserTenantId(String purchaserTenantId) {
    this.purchaserTenantId = purchaserTenantId;
    return this;
  }

   /**
   * 购方租户id
     *
   * @return purchaserTenantId
  **/
  @ApiModelProperty(value = "购方租户id")
  public String getPurchaserTenantId() {
    return purchaserTenantId;
  }

  public void setPurchaserTenantId(String purchaserTenantId) {
    this.purchaserTenantId = purchaserTenantId;
  }

    /**
     * 购方公司代码
     *
     * @return
     **/
    @ApiModelProperty(value = "购方公司代码")
    public String getPurchaserId() {
        return purchaserId;
    }

    public void setPurchaserId(String purchaserId) {
        this.purchaserId = purchaserId;
  }



  @JsonIgnore
  public PreInvoiceMainInfo purchaserNo(String purchaserNo) {
    this.purchaserNo = purchaserNo;
    return this;
  }

   /**
   * 购方租户公司编号
     *
   * @return purchaserNo
  **/
  @ApiModelProperty(value = "购方租户公司编号")
  public String getPurchaserNo() {
    return purchaserNo;
  }

  public void setPurchaserNo(String purchaserNo) {
    this.purchaserNo = purchaserNo;
  }

  @JsonIgnore
  public PreInvoiceMainInfo purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方纳税人识别号
     *
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方纳税人识别号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public PreInvoiceMainInfo purchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
    return this;
  }

   /**
   * 购方电话
     *
   * @return purchaserTel
  **/
  @ApiModelProperty(value = "购方电话")
  public String getPurchaserTel() {
    return purchaserTel;
  }

  public void setPurchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
  }

  @JsonIgnore
  public PreInvoiceMainInfo purchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
    return this;
  }

   /**
   * 购方地址
     *
   * @return purchaserAddress
  **/
  @ApiModelProperty(value = "购方地址")
  public String getPurchaserAddress() {
    return purchaserAddress;
  }

  public void setPurchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
  }

  @JsonIgnore
  public PreInvoiceMainInfo purchaserBankName(String purchaserBankName) {
    this.purchaserBankName = purchaserBankName;
    return this;
  }

   /**
   * 购方银行名称
     *
   * @return purchaserBankName
  **/
  @ApiModelProperty(value = "购方银行名称")
  public String getPurchaserBankName() {
    return purchaserBankName;
  }

  public void setPurchaserBankName(String purchaserBankName) {
    this.purchaserBankName = purchaserBankName;
  }

  @JsonIgnore
  public PreInvoiceMainInfo purchaserBankAccount(String purchaserBankAccount) {
    this.purchaserBankAccount = purchaserBankAccount;
    return this;
  }

   /**
   * 购方银行账号
     *
   * @return purchaserBankAccount
  **/
  @ApiModelProperty(value = "购方银行账号")
  public String getPurchaserBankAccount() {
    return purchaserBankAccount;
  }

  public void setPurchaserBankAccount(String purchaserBankAccount) {
    this.purchaserBankAccount = purchaserBankAccount;
  }

  @JsonIgnore
  public PreInvoiceMainInfo invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型
     *
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public PreInvoiceMainInfo businessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
    return this;
  }

   /**
   * 业务单据类型
     *
   * @return businessBillType
  **/
  @ApiModelProperty(value = "业务单据类型")
  public String getBusinessBillType() {
    return businessBillType;
  }

  public void setBusinessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
  }

  @JsonIgnore
  public PreInvoiceMainInfo salesbillType(String salesbillType) {
    this.salesbillType = salesbillType;
    return this;
  }

   /**
   * 单据类型
     *
   * @return salesbillType
  **/
  @ApiModelProperty(value = "单据类型")
  public String getSalesbillType() {
    return salesbillType;
  }

  public void setSalesbillType(String salesbillType) {
    this.salesbillType = salesbillType;
  }

  @JsonIgnore
  public PreInvoiceMainInfo invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
     *
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public PreInvoiceMainInfo invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
     *
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public PreInvoiceMainInfo machineCode(String machineCode) {
    this.machineCode = machineCode;
    return this;
  }

   /**
   * 机器编码
     *
   * @return machineCode
  **/
  @ApiModelProperty(value = "机器编码")
  public String getMachineCode() {
    return machineCode;
  }

  public void setMachineCode(String machineCode) {
    this.machineCode = machineCode;
  }

  @JsonIgnore
  public PreInvoiceMainInfo paperDrawDate(String paperDrawDate) {
    this.paperDrawDate = paperDrawDate;
    return this;
  }

   /**
   * 发票开票日期
     *
   * @return paperDrawDate
  **/
  @ApiModelProperty(value = "发票开票日期")
  public String getPaperDrawDate() {
    return paperDrawDate;
  }

  public void setPaperDrawDate(String paperDrawDate) {
    this.paperDrawDate = paperDrawDate;
  }

  @JsonIgnore
  public PreInvoiceMainInfo checkCode(String checkCode) {
    this.checkCode = checkCode;
    return this;
  }

   /**
   * 校验码
     *
   * @return checkCode
  **/
  @ApiModelProperty(value = "校验码")
  public String getCheckCode() {
    return checkCode;
  }

  public void setCheckCode(String checkCode) {
    this.checkCode = checkCode;
  }

  @JsonIgnore
  public PreInvoiceMainInfo cashierName(String cashierName) {
    this.cashierName = cashierName;
    return this;
  }

   /**
   * 收款人姓名
     *
   * @return cashierName
  **/
  @ApiModelProperty(value = "收款人姓名")
  public String getCashierName() {
    return cashierName;
  }

  public void setCashierName(String cashierName) {
    this.cashierName = cashierName;
  }

  @JsonIgnore
  public PreInvoiceMainInfo checkerName(String checkerName) {
    this.checkerName = checkerName;
    return this;
  }

   /**
   * 复核人姓名
     *
   * @return checkerName
  **/
  @ApiModelProperty(value = "复核人姓名")
  public String getCheckerName() {
    return checkerName;
  }

  public void setCheckerName(String checkerName) {
    this.checkerName = checkerName;
  }

  @JsonIgnore
  public PreInvoiceMainInfo invoicerName(String invoicerName) {
    this.invoicerName = invoicerName;
    return this;
  }

   /**
   * 开票人姓名
     *
   * @return invoicerName
  **/
  @ApiModelProperty(value = "开票人姓名")
  public String getInvoicerName() {
    return invoicerName;
  }

  public void setInvoicerName(String invoicerName) {
    this.invoicerName = invoicerName;
  }

  @JsonIgnore
  public PreInvoiceMainInfo remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
     *
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public PreInvoiceMainInfo electronicSignature(String electronicSignature) {
    this.electronicSignature = electronicSignature;
    return this;
  }

   /**
   * 电子签名
     *
   * @return electronicSignature
  **/
  @ApiModelProperty(value = "电子签名")
  public String getElectronicSignature() {
    return electronicSignature;
  }

  public void setElectronicSignature(String electronicSignature) {
    this.electronicSignature = electronicSignature;
  }

  @JsonIgnore
  public PreInvoiceMainInfo amountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
     *
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public BigDecimal getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public PreInvoiceMainInfo amountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
     *
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public PreInvoiceMainInfo taxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
     *
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public PreInvoiceMainInfo cipherText(String cipherText) {
    this.cipherText = cipherText;
    return this;
  }

   /**
   * 密文
     *
   * @return cipherText
  **/
  @ApiModelProperty(value = "密文")
  public String getCipherText() {
    return cipherText;
  }

  public void setCipherText(String cipherText) {
    this.cipherText = cipherText;
  }

  @JsonIgnore
  public PreInvoiceMainInfo cipherTextTwoCode(String cipherTextTwoCode) {
    this.cipherTextTwoCode = cipherTextTwoCode;
    return this;
  }

   /**
   * 二维密文
     *
   * @return cipherTextTwoCode
  **/
  @ApiModelProperty(value = "二维密文")
  public String getCipherTextTwoCode() {
    return cipherTextTwoCode;
  }

  public void setCipherTextTwoCode(String cipherTextTwoCode) {
    this.cipherTextTwoCode = cipherTextTwoCode;
  }


  @JsonIgnore
  public PreInvoiceMainInfo salesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
    return this;
  }

  public String getSalesbillNo() {
    return salesbillNo;
  }

  public void setSalesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
  }

  @JsonIgnore
  public PreInvoiceMainInfo preInvoiceDetails(List<PreInvoiceDetail> preInvoiceDetails) {
    this.preInvoiceDetails = preInvoiceDetails;
    return this;
  }

  public PreInvoiceMainInfo addPreInvoiceDetailsItem(PreInvoiceDetail preInvoiceDetailsItem) {
    this.preInvoiceDetails.add(preInvoiceDetailsItem);
    return this;
  }

   /**
   * 预制发票明细
     *
   * @return preInvoiceDetails
  **/
  @ApiModelProperty(value = "预制发票明细")
  public List<PreInvoiceDetail> getPreInvoiceDetails() {
    return preInvoiceDetails;
  }

  public void setPreInvoiceDetails(List<PreInvoiceDetail> preInvoiceDetails) {
    this.preInvoiceDetails = preInvoiceDetails;
  }




  @Override
  public int hashCode() {
      return Objects.hash(preInvoiceDetailCount, id, batchNo, sellerTenantId, sellerNo, sellerCode, sellerName, sellerTaxNo, sellerTel, sellerAddress, sellerBankName, sellerBankAccount, purchaserName, purchaserTenantId, purchaserId, purchaserNo, purchaserTaxNo, purchaserTel, purchaserAddress, purchaserBankName, purchaserBankAccount, invoiceType, businessBillType, salesbillType, invoiceCode, invoiceNo, machineCode, paperDrawDate, checkCode, cashierName, checkerName, invoicerName, remark, electronicSignature, amountWithTax, amountWithoutTax, taxAmount, cipherText, cipherTextTwoCode, preInvoiceDetails);
  }


  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  public int getSaleListFileFlag() {
    return saleListFileFlag;
  }

  public void setSaleListFileFlag(int saleListFileFlag) {
    this.saleListFileFlag = saleListFileFlag;
  }

  @Override
  public String toString() {
    return "PreInvoiceMainInfo{" +
            "preInvoiceDetailCount=" + preInvoiceDetailCount +
            ", id=" + id +
            ", batchNo=" + batchNo +
            ", outBatchNo=" + outBatchNo +
            ", sellerTenantId='" + sellerTenantId + '\'' +
            ", sellerNo='" + sellerNo + '\'' +
            ", sellerCode='" + sellerCode + '\'' +
            ", sellerName='" + sellerName + '\'' +
            ", sellerTaxNo='" + sellerTaxNo + '\'' +
            ", sellerTel='" + sellerTel + '\'' +
            ", sellerAddress='" + sellerAddress + '\'' +
            ", sellerBankName='" + sellerBankName + '\'' +
            ", sellerBankAccount='" + sellerBankAccount + '\'' +
            ", purchaserName='" + purchaserName + '\'' +
            ", purchaserTenantId='" + purchaserTenantId + '\'' +
            ", purchaserId='" + purchaserId + '\'' +
            ", purchaserNo='" + purchaserNo + '\'' +
            ", purchaserTaxNo='" + purchaserTaxNo + '\'' +
            ", purchaserTel='" + purchaserTel + '\'' +
            ", purchaserAddress='" + purchaserAddress + '\'' +
            ", purchaserBankName='" + purchaserBankName + '\'' +
            ", purchaserBankAccount='" + purchaserBankAccount + '\'' +
            ", invoiceType='" + invoiceType + '\'' +
            ", businessBillType='" + businessBillType + '\'' +
            ", salesbillType='" + salesbillType + '\'' +
            ", invoiceCode='" + invoiceCode + '\'' +
            ", invoiceNo='" + invoiceNo + '\'' +
            ", machineCode='" + machineCode + '\'' +
            ", paperDrawDate='" + paperDrawDate + '\'' +
            ", checkCode='" + checkCode + '\'' +
            ", cashierName='" + cashierName + '\'' +
            ", checkerName='" + checkerName + '\'' +
            ", invoicerName='" + invoicerName + '\'' +
            ", remark='" + remark + '\'' +
            ", electronicSignature='" + electronicSignature + '\'' +
            ", amountWithTax=" + amountWithTax +
            ", amountWithoutTax=" + amountWithoutTax +
            ", taxAmount=" + taxAmount +
            ", cipherText='" + cipherText + '\'' +
            ", taxRateStr='" + taxRateStr + '\'' +
            ", taxAmountStr='" + taxAmountStr + '\'' +
            ", cipherTextTwoCode='" + cipherTextTwoCode + '\'' +
            ", preInvoiceDetails=" + preInvoiceDetails +
            ", saleListFileFlag=" + saleListFileFlag +
            ", displayPriceQuality=" + displayPriceQuality +
            '}';
  }

  public String getTaxRateStr() {
        return taxRateStr;
    }

    public void setTaxRateStr(String taxRateStr) {
        this.taxRateStr = taxRateStr;
    }

    public String getTaxAmountStr() {
        return taxAmountStr;
    }

    public void setTaxAmountStr(String taxAmountStr) {
        this.taxAmountStr = taxAmountStr;
    }

  public Long getOutBatchNo() {
    return outBatchNo;
  }

  public void setOutBatchNo(Long outBatchNo) {
    this.outBatchNo = outBatchNo;
  }

  public int getDisplayPriceQuality() {
    return displayPriceQuality;
  }

  public void setDisplayPriceQuality(int displayPriceQuality) {
    this.displayPriceQuality = displayPriceQuality;
  }
}
