package com.xforceplus.seller.invoice.client.model;

import com.xforceplus.xplatframework.apimodel.BaseResponse;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 项目名称:
 * 模块名称:
 * 说明:
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2019/8/25 18:08
 */
public class QueryMakeOutFailResponse extends BaseResponse {

    @ApiModelProperty(value = "总数")
    private int total;

    @ApiModelProperty(value = "失败列表")
    private List<MakeOutFailInfo> result;

    public QueryMakeOutFailResponse ok(List<MakeOutFailInfo> result, int total, String message){
        this.setCode(Response.OK);
        this.total = total;
        this.setMessage(message);
        this.result = result;
        return this;
    }

    public QueryMakeOutFailResponse fail(String message){
        this.setCode(Response.Fail);
        this.setMessage(message);
        return this;
    }

    public List<MakeOutFailInfo> getResult() {
        return result;
    }

    public void setResult(List<MakeOutFailInfo> result) {
        this.result = result;
    }

    public int getTotal() {
        return total;
    }

    public void setTotal(int total) {
        this.total = total;
    }
}
