package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 分页数据
 */
@ApiModel(description = "分页数据")

@JsonInclude(NON_NULL)
public class SellerPreInvoiceOperationQueryResult {

    @JsonProperty("code")
    private Integer code = 1;

    @JsonProperty("message")
    private String message = "获取成功!";

    @JsonProperty("total")
    private Long total = null;

    @JsonProperty("preInvoices")
    private List<SellerPreInvoice> preInvoices = new ArrayList<SellerPreInvoice>();

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @JsonIgnore
    public SellerPreInvoiceOperationQueryResult total(Long total) {
        this.total = total;
        return this;
    }

    /**
     * Get total
     *
     * @return total
     **/
    @ApiModelProperty(value = "")
    public Long getTotal() {
        return total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    @JsonIgnore
    public SellerPreInvoiceOperationQueryResult preInvoices(List<SellerPreInvoice> preInvoices) {
        this.preInvoices = preInvoices;
        return this;
    }

    public SellerPreInvoiceOperationQueryResult addPreInvoicesItem(SellerPreInvoice preInvoicesItem) {
        this.preInvoices.add(preInvoicesItem);
        return this;
    }

    /**
     * Get preInvoices
     *
     * @return preInvoices
     **/
    @ApiModelProperty(value = "")
    public List<SellerPreInvoice> getPreInvoices() {
        return preInvoices;
    }

    public void setPreInvoices(List<SellerPreInvoice> preInvoices) {
        this.preInvoices = preInvoices;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SellerPreInvoiceOperationQueryResult sellerPreInvoiceQueryResponseResult = (SellerPreInvoiceOperationQueryResult) o;
        return Objects.equals(this.total, sellerPreInvoiceQueryResponseResult.total) &&
                Objects.equals(this.preInvoices, sellerPreInvoiceQueryResponseResult.preInvoices);
    }

    @Override
    public int hashCode() {
        return Objects.hash(total, preInvoices);
    }


    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }


    @Override
    public String toString() {
        return "SellerPreInvoiceQueryResponseResult{" +
                ", total=" + total +
                ", preInvoices=" + preInvoices +
                '}';
    }
}
