package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 修改预制发票备注请求参数
 */
@ApiModel(description = "修改预制发票备注请求参数")

@JsonInclude(NON_NULL)
public class UpdPreInvoiceRequest {

    @JsonProperty("condition")
    private ConditionRequest condition = null;

    @JsonProperty("excludes")
    private List<Long> excludes = new ArrayList<Long>();

    @JsonProperty("includes")
    private List<Long> includes = new ArrayList<Long>();

    @JsonProperty("isAllSelect")
    @NotNull
    private Integer isAllSelect;

    @JsonProperty("sort")
    private Sort sort = null;

    @JsonProperty("remark")
    private String remark = null;

    public ConditionRequest getCondition() {
        return condition;
    }

    public void setCondition(ConditionRequest condition) {
        this.condition = condition;
    }

    public List<Long> getExcludes() {
        return excludes;
    }

    public void setExcludes(List<Long> excludes) {
        this.excludes = excludes;
    }

    public List<Long> getIncludes() {
        return includes;
    }

    public void setIncludes(List<Long> includes) {
        this.includes = includes;
    }

    public Integer getIsAllSelect() {
        return isAllSelect;
    }

    public void setIsAllSelect(Integer isAllSelect) {
        this.isAllSelect = isAllSelect;
    }

    public Sort getSort() {
        return sort;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
