/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.client.model.open;

import io.swagger.annotations.ApiModel;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

@ApiModel(description="\u67e5\u8be2\u7c7b\u578b")
public enum Operator {
    eq("EqualTo"),
    like("Like"),
    range("Between"),
    in("In"),
    not_in("NotIn"),
    gt("GreaterThan"),
    ge("GreaterThanOrEqualTo"),
    lt("LessThan"),
    le("LessThanOrEqualTo"),
    ne("NotEqualTo");

    private final String value;

    public static boolean isValid(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        return Arrays.stream(Operator.values()).anyMatch(item -> item.name().endsWith(name));
    }

    public static Operator getEnumByName(String name) {
        for (Operator value : Operator.values()) {
            if (!value.name().equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    private Operator(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}

