package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.AbandonInvoiceCheckRequest;
import com.xforceplus.seller.invoice.client.model.AbandonInvoiceCheckResponse;
import com.xforceplus.seller.invoice.client.model.AbandonSellerInvoiceRequest;
import com.xforceplus.xplatframework.apimodel.BaseAsyncResponse;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 项目名称:
 * 模块名称:
 * 说明:
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2019/6/25 10:00
 */
@Api(value = "AbandonInvoice", description = "the AbandonInvoice API")
public interface AbandonInvoiceApi {

    @ApiOperation(value = "作废 - 通用校验接口", notes = "", response = AbandonInvoiceCheckResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"AbandonInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "作废校验接口返回", response = AbandonInvoiceCheckResponse.class)})
    @RequestMapping(value = "/abandon/abandon-check",
            produces = {"application/json"},
            method = RequestMethod.POST)
    AbandonInvoiceCheckResponse abandonInvoiceCheck(@ApiParam(value = "作废发票校验条件", required = true) @RequestBody AbandonInvoiceCheckRequest abandonInvoiceCheckRequest);

    @ApiOperation(value = "发票作废 - 按照发票号作废", notes = "", response = BaseAsyncResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"AbandonInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = BaseAsyncResponse.class)})
    @RequestMapping(value = "/abandon/send-abandon-request",
            produces = {"application/json"},
            method = RequestMethod.POST)
    BaseAsyncResponse abandonInvoice(@ApiParam(value = "待作废发票id列表", required = true) @RequestBody AbandonSellerInvoiceRequest abandonSellerInvoiceRequest);

    @ApiOperation(value = "线下发票作废 - 按照发票号作废", notes = "", response = BaseAsyncResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"AbandonInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = BaseAsyncResponse.class)})
    @RequestMapping(value = "/abandon/send-abandon-offline-request",
            produces = {"application/json"},
            method = RequestMethod.POST)
    BaseAsyncResponse abandonInvoiceOffline(@ApiParam(value = "待作废发票id列表", required = true) @RequestBody AbandonSellerInvoiceRequest abandonSellerInvoiceRequest);

}
