package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.SellerStatisticsInfo;
import com.xforceplus.seller.invoice.client.StatisticsPageQueryResult;
import com.xforceplus.seller.invoice.client.model.*;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;


@Api(value = "invoice", description = "the invoice API")
public interface InvoiceExportApi {
    @ApiOperation(value = "由查询条件获取searchModel", notes = "", response = SearchModelResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "Export", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = SearchModelResponse.class) })
    @RequestMapping(value = "/export/getPreInvoiceSearchModelResponse",
            produces = { "application/json" },
            method = RequestMethod.POST)
    SearchModelResponse getPreInvoiceSearchModelResponse(@ApiParam(value = "发票查询请求") @RequestBody PreInvoiceRequest preInvoiceRequest);

    @ApiOperation(value = "根据预制发票Id查询原单据号", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "Export", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = SearchModelResponse.class) })
    @RequestMapping(value = "/export/getSalesbillNoByPreInvoiceId",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response getSalesbillNoByPreInvoiceId(@ApiParam(value = "根据预制发票Id查询原单据号") @RequestBody PreInvoiceId PreInvoiceIdl);


    @ApiOperation(value = "组装文件导出发票的查询对象(带权限和默认条件设置) searchModel", notes = "", response = SearchModelResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "Export", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = SearchModelResponse.class) })
    @RequestMapping(value = "/export/querySearchModelResponse",
            produces = { "application/json" },
            method = RequestMethod.POST)
    SearchModelResponse querySearchModelResponse(@ApiParam(value = "发票的查询条件") @RequestBody ExportSellerInvoiceRequest exportSellerInvoiceRequest);

    @ApiOperation(value = "根据排序好的发票id集合查询明细", notes = "", response = Response.class,
            authorizations = {@Authorization("x-access-token"), @Authorization("x-operation-token")},
            tags = {"InvoiceOperation"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/export/details/by-sorted-ids",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<List<InvoiceItem>> queryInvoiceDetailsBySortedIds(@RequestBody QueryItemBySortedIdsRequest request);

    @ApiOperation(value = "根据排序id查询预制发票明细", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/export/preDetail/by-sorted-ids",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<List<PreInvoiceDetail>> queryPreDetailBySortedIds(@RequestBody QueryItemBySortedIdsRequest request);

    @ApiOperation(value = "查询导出的count", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/export/count",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<QueryExportCountReply> queryExportCountByCondition(@RequestBody QueryExportCountRequest request);

    @ApiOperation(value = "mysql查询导出的发票", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/export/invoiceExt",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<PageQueryData<SellerInvoiceInfo>> queryExportInvoiceExtByCondition(@RequestBody QueryExportDataRequest request);

    @ApiOperation(value = "mysql查询导出的发票", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/export/invoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<PageQueryData<InvoiceDetails>> queryExportInvoiceByCondition(@RequestBody QueryExportDataRequest request);


    @ApiOperation(value = "mysql查询导出的预制发票", response = SellerPreInvoiceQueryResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = SellerPreInvoiceQueryResponse.class)})
    @RequestMapping(value = "/export/pre-invoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<PageQueryData<PreInvoiceExportDto>> queryExportPreInvoiceByCondition(@RequestBody QueryExportDataRequest request);

    @ApiOperation(value = "组装文件导出商户发票的查询对象(带权限和默认条件设置) searchModel", notes = "", response = SearchModelResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "Export", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = SearchModelResponse.class) })
    @RequestMapping(value = "/export/queryMerchantSearchModel",
            produces = { "application/json" },
            method = RequestMethod.POST)
    SearchModelResponse queryMerchantSearchModel(@ApiParam(value = "发票的查询条件") @RequestBody ExportSellerInvoiceRequest exportSellerInvoiceRequest);

    @ApiOperation(value = "查询待发票-用于导出发票-pdf生成（含销货清单）", notes = "", response = SearchModelResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "Export", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = SearchModelResponse.class) })
    @RequestMapping(value = "/export/queryInvoiceAndGeneratePdf",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response<List<SellerInvoiceInfo>> queryInvoiceAndGeneratePdf(@ApiParam(value = "查询待导出pdf发票") @RequestBody ExportInvoicePDFRequest exportInvoicePDFRequest);


    @ApiOperation(value = "小规模纳税人统计页面导出", response = Response.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags = {"MarkoutStatistic",})
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/export/statistics",
        produces = {"application/json"},
        method = RequestMethod.POST)
    Response<StatisticsPageQueryResult> queryExportStatisticsByCondition(@RequestBody SellerStatisticsExportByConditionRequest request);

    @ApiOperation(value = "小规模纳税人统计页面导出数量查询", response = Response.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags = {"MarkoutStatistic",})
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/export/statistics/count",
        produces = {"application/json"},
        method = RequestMethod.POST)
    Response<Long> queryExportStatisticsCountByCondition(@RequestBody SellerStatisticsExportByConditionRequest request);

}
