package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.*;
import com.xforceplus.seller.invoice.client.model.open.OpenResponse;
import com.xforceplus.seller.invoice.client.model.open.v2.pre.NeedOnlineTaxNoResult;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * 项目名称:  phoenix-seller-invoice
 * 模块名称:
 * 说明:
 * JDK 版本: JDK1.8
 *
 * @author 作者：chenqiguang
 * 创建日期：2019-02-28
 */
@Api(value = "preInvoiceToBill", description = "the preInvoiceToBill API")
public interface PreInvoiceOperationApi {

    @ApiOperation(value = "批量更新预制发票红字信息", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "SellerPreInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/preInvoice/modifyRedInfo",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response modifyRedInfo(@ApiParam(value = "批量更新预制发票红字信息", required = true) @RequestBody List<ModifyRedInfoRequest> modifyRedInfoRequests);

    @ApiOperation(value = "修改预制发票备注", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "修改结果", response = Response.class)})
    @RequestMapping(value = "/preInvoice/updatePreviewInvoicesRemark",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response updatePreviewInvoicesRemark(@ApiParam(value = "更新预制发票备注请求条件") @RequestBody UpdatePreInvoicesRemarkRequest updatePreInvoicesRemarkRequest);

    @ApiOperation(value = "红冲作废预制发票关系", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "预制发票关系", response = Response.class)})
    @RequestMapping(value = "/redandinvalid/relation",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response redAndInvalidRelation(@ApiParam(value = "更新预制发票备注请求条件") @RequestBody PreinvoiceRelationRequest request);


    @ApiOperation(value = "更新预制发票明细", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "更新预制发票明细", response = Response.class)})
    @RequestMapping(value = "/detail/update",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<Object> updatePreDetails(@ApiParam(value = "更新预制发票明细") @RequestBody UpdatePreDetailRequest request);

    @ApiOperation(value = "批量新增预制发票", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "批量新增预制发票", response = Response.class)})
    @RequestMapping(value = "/batch/save",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<Object> batchPreInvoices(@ApiParam(value = "新增预制发票条件") @RequestBody PreInvoicesRequest request);

    @ApiOperation(value = "查询待数电登录的租户税号", notes = "供预警通知平台使用", response = OpenResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags = {"openInvoiceOperation",})
    @ApiResponses(value = {@ApiResponse(code = 200, message = "结果", response = OpenResponse.class)})
    @RequestMapping(value = "/all-electric-retry/need-online-taxNos", produces = {"application/json"}, method = RequestMethod.GET)
    OpenResponse<NeedOnlineTaxNoResult> countNeedOnlineTaxNos();
}
