package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.seller.invoice.client.model.operation.ItemInfo;
import com.xforceplus.seller.invoice.client.model.update.OperationConfigItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 作废校验接口结果
 */
@ApiModel(description = "作废校验接口结果")

@JsonInclude(NON_NULL)
@Getter
@Setter
public class AbandonInvoiceConfigResult {
    @ApiModelProperty(value = "校验结果 0-校验失败 1-校验成功")
    @JsonProperty("checked")
    private Integer checked;

    @ApiModelProperty(value = "发票作废释放方式")
    @JsonProperty("checkConfigs")
    private List<OperationConfigItem> checkConfigs;

    @ApiModelProperty(value = "可作废发票id列表")
    @JsonProperty("invoiceIds")
    private List<String> invoiceIds;

    @ApiModelProperty(value = "含税总金额")
    @JsonProperty("totalAmountWithTax")
    private BigDecimal totalAmountWithTax ;

    @ApiModelProperty(value = "不含税总金额")
    @JsonProperty("totalAmountWithOutTax")
    private BigDecimal totalAmountWithOutTax ;

    @ApiModelProperty(value = "总税额")
    @JsonProperty("totalTaxAmount")
    private BigDecimal totalTaxAmount ;

    @ApiModelProperty(value = "已勾选发票张数")
    @JsonProperty("selectedSheets")
    private String selectedSheets ;

    @ApiModelProperty(value = "可作废发票张数")
    @JsonProperty("canAbandonSheets")
    private String canAbandonSheets ;

    @ApiModelProperty(value = "发票校验信息列表")
    @JsonProperty("abandonInvoiceList")
    private List<AbandonInvoiceCheckInfo> abandonInvoiceList;

    @ApiModelProperty(value = "作废原因列表")
    @JsonProperty("abandonOperation")
    private List<ItemInfo> abandonOperation;

    @ApiModelProperty(value = "国税来源")
    @JsonProperty("taxInvoiceSource")
    private String taxInvoiceSource;

}
