package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.util.ArrayList;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@JsonInclude(NON_NULL)
@AllArgsConstructor
@NoArgsConstructor
@Data
@ToString
public class AbandonSellerInvoiceRequest {
  @ApiModelProperty(value = "可作废发票id列表")
  @JsonProperty("invoiceIds")
  private List<Long> invoiceIds = new ArrayList<Long>();

  @ApiModelProperty(value = "作废释放模式1-作废后可对预制发票再次开具 2-作废后可对业务单明细选择并开具 3-作废后无法再次开具")
  @JsonProperty("releaseType")
  private Integer releaseType = null;

  @ApiModelProperty(value = "作废原因")
  @JsonProperty("reason")
  private String reason = null;

  @ApiModelProperty(value = "状态")
  @JsonProperty("status")
  private Integer status;

  @ApiModelProperty(value = "自定义作废原因")
  @JsonProperty("customAbandonReason")
  private String customAbandonReason = null;

  @ApiModelProperty(value = "轮训id")
  @JsonProperty("taskId")
  private Long taskId = null;

  @ApiModelProperty(value = "来源")
  @JsonProperty("requestSource")
  private String requestSource = null;

  @ApiModelProperty(value = "是否线下")
  @JsonProperty("offFlag")
  private Boolean offFlag=false;

  @ApiModelProperty(value = "开票人")
  @JsonProperty("issuer")
  private String issuer;

  @ApiModelProperty(value = "数电票作废原因：invoiceError:开票有误 taxServiceEnd:服务中止 salesReturn:销货退回 other:其他")
  @JsonProperty("cancelReason")
  private String cancelReason;

  @ApiModelProperty(value = "作废详细原因（当作废原因为other时 此项必填）")
  @JsonProperty("cancelReasonDetail")
  private String cancelReasonDetail;

}
