package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 项目名称:
 * 模块名称:
 * 说明:
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2019/8/8 18:38
 */
@JsonInclude(NON_NULL)
@Data
public class AutoIssueRequest {
    @ApiModelProperty(value = "预制发票id")
    @JsonProperty("preInvoiceIdList")
    private List<Long> preInvoiceIdList;
    @ApiModelProperty(value = "租户Id")
    @JsonProperty("sellerGroupId")
    private Long sellerGroupId;
    @ApiModelProperty(value = "批次号")
    @JsonProperty("batchNo")
    private Long batchNo;
    @ApiModelProperty(value = "自动开具终端编码")
    @JsonProperty("terminalCode")
    private String terminalCode;
    @ApiModelProperty(value = "自动开具终端名称")
    @JsonProperty("terminalName")
    private String terminalName;

    @ApiModelProperty(value = "开具模式")
    @JsonProperty("mode")
    private String mode;

    @ApiModelProperty(value = "下一张发票号码")
    @JsonProperty("nextInvoiceNo")
    private String nextInvoiceNo;

    @ApiModelProperty(value = "下一张发票代码")
    @JsonProperty("nextInvoiceCode")
    private String nextInvoiceCode;
}
